/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controllermanager;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.gamepad.GamepadController;
import dev.isxander.controlify.controller.gamepademulated.EmulatedGamepadController;
import dev.isxander.controlify.controller.joystick.CompoundJoystickController;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.DebugLog;
import dev.isxander.controlify.utils.Log;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public abstract class AbstractControllerManager
implements ControllerManager {
    protected final Controlify controlify;
    protected final class_310 minecraft;
    protected final Map<String, Controller<?, ?>> controllersByUid = new Object2ObjectOpenHashMap();

    public AbstractControllerManager() {
        this.controlify = Controlify.instance();
        this.minecraft = class_310.method_1551();
        this.minecraft.method_1478().method_14486(Controlify.id("controllers/gamecontrollerdb.txt")).ifPresent(this::loadGamepadMappings);
    }

    public Optional<Controller<?, ?>> createOrGet(int joystickIndex, ControllerHIDService.ControllerHIDInfo hidInfo) {
        try {
            Optional<String> uid = hidInfo.createControllerUID();
            if (uid.isPresent() && this.controllersByUid.containsKey(uid.get())) {
                return Optional.of(this.controllersByUid.get(uid.get()));
            }
            if (hidInfo.type().dontLoad()) {
                DebugLog.log("Preventing load of controller #" + joystickIndex + " because its type prevents loading.", new Object[0]);
                return Optional.empty();
            }
            if (this.isControllerGamepad(joystickIndex) && !DebugProperties.FORCE_JOYSTICK && !hidInfo.type().forceJoystick()) {
                GamepadController controller = new GamepadController(joystickIndex, hidInfo);
                this.addController(joystickIndex, controller);
                return Optional.of(controller);
            }
            EmulatedGamepadController controller = new EmulatedGamepadController(joystickIndex, hidInfo);
            this.addController(joystickIndex, controller);
            return Optional.of(controller);
        }
        catch (Throwable e) {
            class_128 crashReport = class_128.method_560((Throwable)e, (String)("Creating controller #" + joystickIndex));
            class_129 category = crashReport.method_562("Controller Info");
            category.method_578("Joystick ID", (Object)joystickIndex);
            category.method_578("Controller identification", (Object)hidInfo.type());
            category.method_578("HID path", (Object)hidInfo.hidDevice().map(HIDDevice::path).orElse("N/A"));
            category.method_578("HID service status", (Object)(Controlify.instance().controllerHIDService().isDisabled() ? "Disabled" : "Enabled"));
            category.method_578("GLFW name", (Object)Optional.ofNullable(this.getControllerSystemName(joystickIndex)).orElse("N/A"));
            throw new class_148(crashReport);
        }
    }

    @Override
    public void tick(boolean outOfFocus) {
        for (Controller<?, ?> controller : this.getConnectedControllers()) {
            if (!outOfFocus) {
                ControllerUtils.wrapControllerError(controller::updateState, "Updating controller state", controller);
            } else {
                ControllerUtils.wrapControllerError(controller::clearState, "Clearing controller state", controller);
            }
            ((ControlifyEvents.ControllerStateUpdate)ControlifyEvents.CONTROLLER_STATE_UPDATE.invoker()).onControllerStateUpdate(controller);
        }
    }

    protected void onControllerConnected(Controller<?, ?> controller, boolean hotplug) {
        Log.LOGGER.info("Controller connected: {}", (Object)ControllerUtils.createControllerString(controller));
        boolean newController = this.controlify.config().loadOrCreateControllerData(controller);
        ((ControlifyEvents.ControllerConnected)ControlifyEvents.CONTROLLER_CONNECTED.invoker()).onControllerConnected(controller, hotplug, newController);
    }

    protected void onControllerRemoved(Controller<?, ?> controller) {
        Log.LOGGER.info("Controller disconnected: {}", (Object)ControllerUtils.createControllerString(controller));
        controller.hidInfo().ifPresent(this.controlify.controllerHIDService()::unconsumeController);
        this.removeController(controller.uid());
        this.checkCompoundJoysticks();
        ((ControlifyEvents.ControllerDisconnected)ControlifyEvents.CONTROLLER_DISCONNECTED.invoker()).onControllerDisconnected(controller);
    }

    protected void addController(int id, Controller<?, ?> controller) {
        this.controllersByUid.put(controller.uid(), controller);
        this.checkCompoundJoysticks();
    }

    protected void removeController(String uid) {
        Controller<?, ?> prev = this.controllersByUid.remove(uid);
        if (prev != null) {
            prev.close();
        }
        this.checkCompoundJoysticks();
    }

    @Override
    public List<Controller<?, ?>> getConnectedControllers() {
        return ImmutableList.copyOf(this.controllersByUid.values());
    }

    @Override
    public boolean isControllerConnected(String uid) {
        return this.controllersByUid.containsKey(uid);
    }

    @Override
    public void close() {
        this.controllersByUid.values().forEach(Controller::close);
    }

    protected abstract void loadGamepadMappings(class_3298 var1);

    protected abstract String getControllerSystemName(int var1);

    private void checkCompoundJoysticks() {
        Controlify.instance().config().getCompoundJoysticks().values().forEach(info -> {
            try {
                if (info.isLoaded() && !info.canBeUsed()) {
                    Log.LOGGER.warn("Unloading compound joystick " + info.friendlyName() + " due to missing controllers.");
                    this.removeController(info.type().mappingId());
                }
                if (!info.isLoaded() && info.canBeUsed()) {
                    Log.LOGGER.info("Loading compound joystick " + info.type().mappingId() + ".");
                    CompoundJoystickController controller = info.attemptCreate().orElseThrow();
                    this.controllersByUid.put(info.type().mappingId(), controller);
                    Controlify.instance().config().loadOrCreateControllerData(controller);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

