/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controllermanager;

import com.google.common.io.ByteStreams;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controllermanager.AbstractControllerManager;
import dev.isxander.controlify.utils.Log;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

public class GLFWControllerManager
extends AbstractControllerManager {
    private final class_310 minecraft = class_310.method_1551();

    public GLFWControllerManager() {
        this.minecraft.method_1478().method_14486(Controlify.id("controllers/gamecontrollerdb.txt")).ifPresent(this::loadGamepadMappings);
        this.setupCallbacks();
    }

    private void setupCallbacks() {
        GLFW.glfwSetJoystickCallback((jid, event) -> {
            try {
                if (event == 262145) {
                    this.createOrGet(jid, this.controlify.controllerHIDService().fetchType(jid)).ifPresent(controller -> this.onControllerConnected((Controller<?, ?>)controller, true));
                } else if (event == 262146) {
                    this.getController(jid).ifPresent(this::onControllerRemoved);
                }
            }
            catch (Throwable e) {
                Log.LOGGER.error("Failed to handle controller connect/disconnect event", e);
            }
        });
    }

    @Override
    public void discoverControllers() {
        for (int i = 0; i < 15; ++i) {
            if (!GLFW.glfwJoystickPresent((int)i)) continue;
            Optional<Controller<?, ?>> controllerOpt = this.createOrGet(i, this.controlify.controllerHIDService().fetchType(i));
            controllerOpt.ifPresent(controller -> this.onControllerConnected((Controller<?, ?>)controller, false));
        }
    }

    @Override
    public boolean probeConnectedControllers() {
        return GLFWControllerManager.areControllersConnected();
    }

    @Override
    protected void loadGamepadMappings(class_3298 resource) {
        Log.LOGGER.debug("Loading gamepad mappings...");
        try (InputStream is = resource.method_14482();){
            byte[] bytes = ByteStreams.toByteArray((InputStream)is);
            ByteBuffer buffer = MemoryUtil.memASCIISafe((CharSequence)new String(bytes));
            if (!GLFW.glfwUpdateGamepadMappings((ByteBuffer)buffer)) {
                Log.LOGGER.error("Failed to load gamepad mappings: {}", (Object)GLFW.glfwGetError(null));
            }
        }
        catch (Throwable e) {
            Log.LOGGER.error("Failed to load gamepad mappings: {}", (Object)e.getMessage());
        }
    }

    private Optional<Controller<?, ?>> getController(int joystickId) {
        return this.controllersByUid.values().stream().filter(controller -> controller.joystickId() == joystickId).findAny();
    }

    @Override
    public boolean isControllerGamepad(int jid) {
        return GLFW.glfwJoystickIsGamepad((int)jid);
    }

    @Override
    protected String getControllerSystemName(int joystickId) {
        return this.isControllerGamepad(joystickId) ? GLFW.glfwGetGamepadName((int)joystickId) : GLFW.glfwGetJoystickName((int)joystickId);
    }

    public static boolean areControllersConnected() {
        return IntStream.range(0, 16).anyMatch(GLFW::glfwJoystickPresent);
    }
}

