/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controllermanager;

import com.google.common.io.ByteStreams;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerType;
import dev.isxander.controlify.controllermanager.AbstractControllerManager;
import dev.isxander.controlify.driver.SDL2NativesManager;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.utils.Log;
import io.github.libsdl4j.api.error.SdlError;
import io.github.libsdl4j.api.event.SDL_Event;
import io.github.libsdl4j.api.event.SDL_EventFilter;
import io.github.libsdl4j.api.event.SdlEvents;
import io.github.libsdl4j.api.gamecontroller.SdlGamecontroller;
import io.github.libsdl4j.api.joystick.SdlJoystick;
import io.github.libsdl4j.api.rwops.SDL_RWops;
import io.github.libsdl4j.api.rwops.SdlRWops;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.class_3298;
import org.apache.commons.lang3.Validate;

public class SDLControllerManager
extends AbstractControllerManager {
    private final Controlify controlify;
    private final Int2ObjectMap<Controller<?, ?>> controllersByJid = new Int2ObjectArrayMap();
    private final SDL_Event event = new SDL_Event();
    private final EventFilter eventFilter;

    public SDLControllerManager() {
        Validate.isTrue((boolean)SDL2NativesManager.isLoaded(), (String)"SDL2 natives must be loaded before creating SDLControllerManager", (Object[])new Object[0]);
        this.controlify = Controlify.instance();
        this.eventFilter = new EventFilter();
        SdlEvents.SDL_SetEventFilter((SDL_EventFilter)this.eventFilter, (Pointer)Pointer.NULL);
    }

    @Override
    public void tick(boolean outOfFocus) {
        super.tick(outOfFocus);
        while (SdlEvents.SDL_PollEvent((SDL_Event)this.event) == 1) {
            switch (this.event.type) {
                case 1541: {
                    int deviceIndex = this.event.jdevice.which;
                    Optional<Controller<?, ?>> controllerOpt = this.createOrGet(deviceIndex, ControllerHIDService.fetchTypeFromSDL(deviceIndex).orElse(new ControllerHIDService.ControllerHIDInfo(ControllerType.UNKNOWN, Optional.empty())));
                    controllerOpt.ifPresent(controller -> this.onControllerConnected((Controller<?, ?>)controller, true));
                    break;
                }
                case 1542: {
                    int jid = this.event.jdevice.which;
                    this.getController(jid).ifPresent(this::onControllerRemoved);
                }
            }
        }
    }

    @Override
    public void discoverControllers() {
        for (int i = 0; i < SdlJoystick.SDL_NumJoysticks(); ++i) {
            Optional<Controller<?, ?>> controllerOpt = this.createOrGet(i, this.controlify.controllerHIDService().fetchType(i));
            controllerOpt.ifPresent(controller -> this.onControllerConnected((Controller<?, ?>)controller, false));
        }
    }

    @Override
    public boolean probeConnectedControllers() {
        return SdlJoystick.SDL_NumJoysticks() > 0;
    }

    @Override
    public boolean isControllerGamepad(int jid) {
        return SdlGamecontroller.SDL_IsGameController((int)jid);
    }

    @Override
    protected String getControllerSystemName(int joystickId) {
        return this.isControllerGamepad(joystickId) ? SdlGamecontroller.SDL_GameControllerNameForIndex((int)joystickId) : SdlJoystick.SDL_JoystickNameForIndex((int)joystickId);
    }

    @Override
    protected void addController(int index, Controller<?, ?> controller) {
        super.addController(index, controller);
        int joystickId = SdlJoystick.SDL_JoystickGetDeviceInstanceID((int)index).intValue();
        this.controllersByJid.put(joystickId, controller);
    }

    private Optional<Controller<?, ?>> getController(int joystickId) {
        return Optional.ofNullable((Controller)this.controllersByJid.get(joystickId));
    }

    @Override
    protected void loadGamepadMappings(class_3298 resource) {
        Log.LOGGER.debug("Loading gamepad mappings...");
        try (InputStream is = resource.method_14482();){
            byte[] bytes = ByteStreams.toByteArray((InputStream)is);
            try (Memory memory = new Memory((long)bytes.length);){
                memory.write(0L, bytes, 0, bytes.length);
                SDL_RWops rw = SdlRWops.SDL_RWFromConstMem((Pointer)memory, (int)bytes.length);
                int count = SdlGamecontroller.SDL_GameControllerAddMappingsFromRW((SDL_RWops)rw, (int)1);
                if (count < 1) {
                    Log.LOGGER.error("Failed to load gamepad mappings: {}", (Object)SdlError.SDL_GetError());
                }
            }
        }
        catch (Throwable e) {
            Log.LOGGER.error("Failed to load gamepad mappings", e);
        }
    }

    private static class EventFilter
    implements SDL_EventFilter {
        private EventFilter() {
        }

        public int filterEvent(Pointer userdata, SDL_Event event) {
            switch (event.type) {
                case 1541: 
                case 1542: {
                    return 1;
                }
            }
            return 0;
        }
    }
}

