/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.config.ControlifyConfig;
import dev.isxander.controlify.gui.screen.DownloadingSDLScreen;
import dev.isxander.controlify.utils.Log;
import dev.isxander.controlify.utils.TrackingBodySubscriber;
import dev.isxander.controlify.utils.TrackingConsumer;
import io.github.libsdl4j.api.Sdl;
import io.github.libsdl4j.api.error.SdlError;
import io.github.libsdl4j.api.hints.SdlHints;
import io.github.libsdl4j.jna.SdlNativeLibraryLoader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class SDL2NativesManager {
    private static final String SDL2_VERSION = "2.28.2-11";
    private static final Map<Target, NativeFileInfo> NATIVE_LIBRARIES = Map.of(new Target(class_156.class_158.field_1133, true, false), new NativeFileInfo("win32-x86-64", "windows64", "dll"), new Target(class_156.class_158.field_1133, false, false), new NativeFileInfo("win32-x86", "window32", "dll"), new Target(class_156.class_158.field_1135, true, false), new NativeFileInfo("linux-x86-64", "linux64", "so"), new Target(class_156.class_158.field_1137, true, false), new NativeFileInfo("darwin-x86-64", "macos-x86_64", "dylib"), new Target(class_156.class_158.field_1137, true, true), new NativeFileInfo("darwin-aarch64", "macos-aarch64", "dylib"));
    private static final String NATIVE_LIBRARY_URL = "https://maven.isxander.dev/releases/dev/isxander/libsdl4j-natives/%s/".formatted("2.28.2-11");
    private static boolean loaded = false;
    private static boolean attemptedLoad = false;
    private static CompletableFuture<Boolean> initFuture;

    public static CompletableFuture<Boolean> maybeLoad() {
        if (initFuture != null) {
            return initFuture;
        }
        if (!Controlify.instance().config().globalSettings().loadVibrationNatives) {
            initFuture = CompletableFuture.completedFuture(false);
            return initFuture;
        }
        if (attemptedLoad) {
            initFuture = CompletableFuture.completedFuture(loaded);
            return initFuture;
        }
        attemptedLoad = true;
        if (!SDL2NativesManager.isSupportedOnThisPlatform()) {
            Log.LOGGER.warn("No native library for current platform, skipping SDL2 load");
            initFuture = CompletableFuture.completedFuture(false);
            return initFuture;
        }
        Path localLibraryPath = SDL2NativesManager.getNativesFolderPath().resolve(Target.CURRENT.getArtifactName());
        if (Files.exists(localLibraryPath, new LinkOption[0])) {
            boolean success = SDL2NativesManager.loadAndStart(localLibraryPath);
            if (success) {
                initFuture = CompletableFuture.completedFuture(true);
                return initFuture;
            }
            Log.LOGGER.warn("Failed to load SDL2 from local file, attempting to re-download");
        }
        initFuture = SDL2NativesManager.downloadAndStart(localLibraryPath);
        return initFuture;
    }

    private static boolean loadAndStart(Path localLibraryPath) {
        try {
            SdlNativeLibraryLoader.loadLibSDL2FromFilePathNow((String)localLibraryPath.toAbsolutePath().toString());
            SDL2NativesManager.startSDL2();
            loaded = true;
            return true;
        }
        catch (Throwable e) {
            Log.LOGGER.error("Failed to start SDL2", e);
            return false;
        }
    }

    private static void startSDL2() {
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_ALLOW_BACKGROUND_EVENTS", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_ACCELEROMETER_AS_JOYSTICK", (String)"0");
        SdlHints.SDL_SetHint((String)"SDL_MAC_BACKGROUND_APP", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_RAWINPUT", (String)"0");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_PS4_RUMBLE", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_PS5_RUMBLE", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_STEAM", (String)"1");
        if (Sdl.SDL_Init((int)25088) != 0) {
            Log.LOGGER.error("Failed to initialise SDL2: " + SdlError.SDL_GetError());
            throw new RuntimeException("Failed to initialise SDL2: " + SdlError.SDL_GetError());
        }
        Log.LOGGER.info("Initialised SDL4j {}", (Object)SDL2_VERSION);
    }

    private static CompletableFuture<Boolean> downloadAndStart(Path localLibraryPath) {
        return ((CompletableFuture)SDL2NativesManager.downloadLibrary(localLibraryPath).thenCompose(success -> {
            if (!success.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            return CompletableFuture.completedFuture(SDL2NativesManager.loadAndStart(localLibraryPath));
        })).thenCompose(success -> class_310.method_1551().method_5385(() -> success));
    }

    private static CompletableFuture<Boolean> downloadLibrary(Path path) {
        try {
            Files.deleteIfExists(path);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (Exception e) {
            Log.LOGGER.error("Failed to delete existing SDL2 native library file", (Throwable)e);
            return CompletableFuture.completedFuture(false);
        }
        String url = NATIVE_LIBRARY_URL + Target.CURRENT.getArtifactName();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(URI.create(url)).build();
        AtomicReference downloadScreen = new AtomicReference();
        class_310 minecraft = class_310.method_1551();
        return httpClient.sendAsync(httpRequest, TrackingBodySubscriber.bodyHandler(HttpResponse.BodyHandlers.ofFileDownload(path.getParent(), StandardOpenOption.WRITE), new TrackingConsumer(total -> {
            DownloadingSDLScreen screen = new DownloadingSDLScreen(minecraft.field_1755, (long)total, path);
            downloadScreen.set(screen);
            minecraft.execute(() -> minecraft.method_1507((class_437)screen));
        }, (received, total) -> ((DownloadingSDLScreen)downloadScreen.get()).updateDownloadProgress((long)received), error -> {
            if (error.isPresent()) {
                Log.LOGGER.error("Failed to download SDL2 native library", (Throwable)error.get());
                minecraft.execute(() -> ((DownloadingSDLScreen)downloadScreen.get()).failDownload((Throwable)error.get()));
            } else {
                Log.LOGGER.debug("Finished downloading SDL2 native library");
                minecraft.execute(() -> ((DownloadingSDLScreen)downloadScreen.get()).finishDownload());
            }
        }))).handle((response, throwable) -> {
            if (throwable != null) {
                Log.LOGGER.error("Failed to download SDL2 native library", throwable);
                return false;
            }
            return true;
        });
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean hasAttemptedLoad() {
        return attemptedLoad;
    }

    public static boolean isSupportedOnThisPlatform() {
        return Target.CURRENT.hasNativeLibrary();
    }

    private static Path getNativesFolderPath() {
        Path nativesFolderPath = FabricLoader.getInstance().getGameDir();
        ControlifyConfig config = Controlify.instance().config();
        String customPath = config.globalSettings().customVibrationNativesPath;
        if (!customPath.isEmpty()) {
            try {
                nativesFolderPath = Path.of(customPath, new String[0]);
            }
            catch (InvalidPathException e) {
                Log.LOGGER.error("Invalid custom SDL2 native library path. Using default and resetting custom path.", (Throwable)e);
                config.globalSettings().customVibrationNativesPath = "";
                config.save();
            }
        }
        return nativesFolderPath.resolve("controlify-natives");
    }

    public record Target(class_156.class_158 os, boolean is64Bit, boolean isARM) {
        public static final Target CURRENT = (Target)class_156.method_656(() -> {
            class_156.class_158 os = class_156.method_668();
            String arch = System.getProperty("os.arch");
            boolean is64bit = arch.contains("64");
            boolean isARM = arch.contains("arm") || arch.contains("aarch");
            return new Target(os, is64bit, isARM);
        });

        public boolean hasNativeLibrary() {
            return NATIVE_LIBRARIES.containsKey(this);
        }

        public String getArtifactName() {
            NativeFileInfo file = NATIVE_LIBRARIES.get(this);
            return "libsdl4j-natives-2.28.2-11-" + file.downloadSuffix + "." + file.fileExtension;
        }

        public boolean isMacArm() {
            return this.os == class_156.class_158.field_1137 && this.isARM;
        }
    }

    public record NativeFileInfo(String folderName, String downloadSuffix, String fileExtension) {
        public Path getNativePath() {
            return this.getSearchPath().resolve(this.folderName).resolve("SDL2." + this.fileExtension);
        }

        public Path getSearchPath() {
            return FabricLoader.getInstance().getGameDir().resolve("controlify-natives").resolve(SDL2NativesManager.SDL2_VERSION);
        }
    }
}

