/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.gamepad;

import com.google.common.collect.Sets;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.BatteryDriver;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.driver.GUIDProvider;
import dev.isxander.controlify.driver.GameControllerDBDriver;
import dev.isxander.controlify.driver.GyroDriver;
import dev.isxander.controlify.driver.NameProviderDriver;
import dev.isxander.controlify.driver.RumbleDriver;
import dev.isxander.controlify.driver.SDL2NativesManager;
import dev.isxander.controlify.driver.SteamDeckDriver;
import dev.isxander.controlify.driver.gamepad.BasicGamepadInputDriver;
import dev.isxander.controlify.driver.gamepad.GLFWGamepadDriver;
import dev.isxander.controlify.driver.gamepad.SDL2GamepadDriver;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.utils.Log;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public record GamepadDrivers(BasicGamepadInputDriver basicGamepadInputDriver, GyroDriver gyroDriver, RumbleDriver rumbleDriver, BatteryDriver batteryDriver, GUIDProvider guidProviderDriver, NameProviderDriver nameProviderDriver) {
    public Set<Driver> getUniqueDrivers() {
        Set drivers = Sets.newIdentityHashSet();
        drivers.addAll(List.of(this.basicGamepadInputDriver, this.gyroDriver, this.rumbleDriver, this.batteryDriver));
        return drivers;
    }

    public void printDrivers() {
        if (DebugProperties.PRINT_DRIVER) {
            Log.LOGGER.info("Drivers in use: Basic Input = '{}', Gyro = '{}', Rumble = '{}', Battery = '{}', Name = '{}', GUID = '{}'", new Object[]{this.basicGamepadInputDriver.getBasicGamepadDetails(), this.gyroDriver.getGyroDetails(), this.rumbleDriver.getRumbleDetails(), this.batteryDriver.getBatteryDriverDetails(), this.nameProviderDriver.getNameProviderDetails(), this.guidProviderDriver.getGUIDProviderDetails()});
        }
    }

    public static GamepadDrivers forController(int jid, Optional<HIDDevice> hid) {
        GLFWGamepadDriver glfwDriver;
        BasicGamepadInputDriver basicGamepadInputDriver = glfwDriver = new GLFWGamepadDriver(jid);
        NameProviderDriver nameProviderDriver = glfwDriver;
        BasicGamepadInputDriver guidProviderDriver = glfwDriver;
        GyroDriver gyroDriver = GyroDriver.UNSUPPORTED;
        RumbleDriver rumbleDriver = RumbleDriver.UNSUPPORTED;
        BatteryDriver batteryDriver = BatteryDriver.UNSUPPORTED;
        if (SDL2NativesManager.isLoaded()) {
            SDL2GamepadDriver sdl2Driver = new SDL2GamepadDriver(jid);
            basicGamepadInputDriver = sdl2Driver;
            gyroDriver = sdl2Driver;
            rumbleDriver = sdl2Driver;
            batteryDriver = sdl2Driver;
            guidProviderDriver = sdl2Driver;
        }
        if (!hid.isPresent() || !hid.get().supportsCommunication() || SteamDeckDriver.isSteamDeck(hid.get().vendorID(), hid.get().productID())) {
            // empty if block
        }
        if (GameControllerDBDriver.isSupported(guidProviderDriver.getGUID())) {
            nameProviderDriver = new GameControllerDBDriver(guidProviderDriver.getGUID());
        }
        return new GamepadDrivers(basicGamepadInputDriver, gyroDriver, rumbleDriver, batteryDriver, (GUIDProvider)((Object)guidProviderDriver), nameProviderDriver);
    }
}

