/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.gamepad;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import dev.isxander.controlify.controller.BatteryLevel;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.BatteryDriver;
import dev.isxander.controlify.driver.GUIDProvider;
import dev.isxander.controlify.driver.GyroDriver;
import dev.isxander.controlify.driver.RumbleDriver;
import dev.isxander.controlify.driver.gamepad.BasicGamepadInputDriver;
import dev.isxander.controlify.driver.gamepad.BasicGamepadState;
import dev.isxander.controlify.utils.Log;
import io.github.libsdl4j.api.error.SdlError;
import io.github.libsdl4j.api.gamecontroller.SDL_GameController;
import io.github.libsdl4j.api.gamecontroller.SdlGamecontroller;
import io.github.libsdl4j.api.joystick.SDL_Joystick;
import io.github.libsdl4j.api.joystick.SdlJoystick;
import net.minecraft.class_3532;

public class SDL2GamepadDriver
implements BasicGamepadInputDriver,
GyroDriver,
RumbleDriver,
BatteryDriver,
GUIDProvider {
    private final SDL_GameController ptrGamepad;
    private BasicGamepadState state = BasicGamepadState.EMPTY;
    private GamepadState.GyroState gyroDelta = new GamepadState.GyroState(0.0f, 0.0f, 0.0f);
    private final boolean isGyroSupported;
    private final boolean isRumbleSupported;
    private final boolean isTriggerRumbleSupported;
    private final String guid;

    public SDL2GamepadDriver(int jid) {
        this.ptrGamepad = SdlGamecontroller.SDL_GameControllerOpen((int)jid);
        if (this.ptrGamepad == null) {
            throw new IllegalStateException("Could not open gamepad: " + SdlError.SDL_GetError());
        }
        this.guid = SdlJoystick.SDL_JoystickGetGUID((SDL_Joystick)SdlGamecontroller.SDL_GameControllerGetJoystick((SDL_GameController)this.ptrGamepad)).toString();
        this.isGyroSupported = SdlGamecontroller.SDL_GameControllerHasSensor((SDL_GameController)this.ptrGamepad, (int)2);
        this.isRumbleSupported = SdlGamecontroller.SDL_GameControllerHasRumble((SDL_GameController)this.ptrGamepad);
        this.isTriggerRumbleSupported = SdlGamecontroller.SDL_GameControllerHasRumbleTriggers((SDL_GameController)this.ptrGamepad);
        if (this.isGyroSupported()) {
            SdlGamecontroller.SDL_GameControllerSetSensorEnabled((SDL_GameController)this.ptrGamepad, (int)2, (boolean)true);
        }
    }

    @Override
    public void update() {
        if (this.isGyroSupported()) {
            float[] gyro = new float[3];
            try (Memory memory = new Memory((long)(gyro.length * 4));){
                if (SdlGamecontroller.SDL_GameControllerGetSensorData((SDL_GameController)this.ptrGamepad, (int)2, (Pointer)memory, (int)3) == 0) {
                    memory.read(0L, gyro, 0, gyro.length);
                    this.gyroDelta = new GamepadState.GyroState(gyro[0], gyro[1], gyro[2]);
                    if (DebugProperties.PRINT_GYRO) {
                        Log.LOGGER.info("Gyro delta: " + this.gyroDelta);
                    }
                } else {
                    Log.LOGGER.error("Could not get gyro data: " + SdlError.SDL_GetError());
                }
            }
        }
        SdlGamecontroller.SDL_GameControllerUpdate();
        GamepadState.AxesState axes = new GamepadState.AxesState(SDL2GamepadDriver.mapShortToFloat(SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.ptrGamepad, (int)0)), SDL2GamepadDriver.mapShortToFloat(SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.ptrGamepad, (int)1)), SDL2GamepadDriver.mapShortToFloat(SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.ptrGamepad, (int)2)), SDL2GamepadDriver.mapShortToFloat(SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.ptrGamepad, (int)3)), SDL2GamepadDriver.mapShortToFloat(SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.ptrGamepad, (int)4)), SDL2GamepadDriver.mapShortToFloat(SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.ptrGamepad, (int)5)));
        GamepadState.ButtonState buttons = new GamepadState.ButtonState(SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)0) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)1) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)2) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)3) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)9) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)10) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)4) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)6) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)5) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)11) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)12) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)13) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)14) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)7) == 1, SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.ptrGamepad, (int)8) == 1);
        this.state = new BasicGamepadState(axes, buttons);
    }

    @Override
    public BasicGamepadState getBasicGamepadState() {
        return this.state;
    }

    @Override
    public boolean rumble(float strongMagnitude, float weakMagnitude) {
        if (!this.isRumbleSupported()) {
            return false;
        }
        if (SdlGamecontroller.SDL_GameControllerRumble((SDL_GameController)this.ptrGamepad, (short)((short)(strongMagnitude * 65535.0f)), (short)((short)(weakMagnitude * 65535.0f)), (int)0) != 0) {
            Log.LOGGER.error("Could not rumble controller: " + SdlError.SDL_GetError());
            return false;
        }
        return true;
    }

    @Override
    public boolean rumbleTrigger(float left, float right) {
        if (!this.isTriggerRumbleSupported()) {
            return false;
        }
        if (SdlGamecontroller.SDL_GameControllerRumbleTriggers((SDL_GameController)this.ptrGamepad, (short)((short)(left * 65535.0f)), (short)((short)(right * 65535.0f)), (int)0) != 0) {
            Log.LOGGER.error("Could not rumble controller trigger: " + SdlError.SDL_GetError());
            return false;
        }
        return true;
    }

    @Override
    public GamepadState.GyroStateC getGyroState() {
        return this.gyroDelta;
    }

    @Override
    public BatteryLevel getBatteryLevel() {
        int powerLevel = SdlJoystick.SDL_JoystickCurrentPowerLevel((SDL_Joystick)SdlGamecontroller.SDL_GameControllerGetJoystick((SDL_GameController)this.ptrGamepad));
        return switch (powerLevel) {
            case -1 -> BatteryLevel.UNKNOWN;
            case 0 -> BatteryLevel.EMPTY;
            case 1 -> BatteryLevel.LOW;
            case 2 -> BatteryLevel.MEDIUM;
            case 3 -> BatteryLevel.FULL;
            case 4 -> BatteryLevel.WIRED;
            case 5 -> BatteryLevel.MAX;
            default -> throw new IllegalStateException("Unexpected value: " + powerLevel);
        };
    }

    @Override
    public boolean isGyroSupported() {
        return this.isGyroSupported;
    }

    @Override
    public boolean isRumbleSupported() {
        return this.isRumbleSupported;
    }

    @Override
    public boolean isTriggerRumbleSupported() {
        return this.isTriggerRumbleSupported;
    }

    @Override
    public String getGUID() {
        return this.guid;
    }

    @Override
    public void close() {
        SdlGamecontroller.SDL_GameControllerClose((SDL_GameController)this.ptrGamepad);
    }

    @Override
    public String getGyroDetails() {
        return "SDL2gp supported=" + this.isGyroSupported();
    }

    @Override
    public String getRumbleDetails() {
        return "SDL2gp supported=" + this.isRumbleSupported() + " trigger=" + this.isTriggerRumbleSupported();
    }

    @Override
    public String getBatteryDriverDetails() {
        return "SDL2gp";
    }

    @Override
    public String getGUIDProviderDetails() {
        return "SDL2gp";
    }

    @Override
    public String getBasicGamepadDetails() {
        return "SDL2gp";
    }

    private static float mapShortToFloat(short value) {
        return class_3532.method_37958((float)value, (float)-32768.0f, (float)0.0f, (float)-1.0f, (float)0.0f) + class_3532.method_37958((float)value, (float)0.0f, (float)32767.0f, (float)0.0f, (float)1.0f);
    }
}

