/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.joystick;

import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.driver.GUIDProvider;
import dev.isxander.controlify.driver.NameProviderDriver;
import dev.isxander.controlify.driver.joystick.BasicJoystickInputDriver;
import dev.isxander.controlify.driver.joystick.BasicJoystickState;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.apache.commons.lang3.Validate;
import org.lwjgl.glfw.GLFW;

public class GLFWJoystickDriver
implements BasicJoystickInputDriver,
NameProviderDriver,
GUIDProvider {
    private final int jid;
    private final String guid;
    private final String name;
    private BasicJoystickState state = BasicJoystickState.EMPTY;

    public GLFWJoystickDriver(int jid) {
        this.jid = jid;
        this.guid = GLFW.glfwGetJoystickGUID((int)jid);
        this.name = GLFW.glfwGetJoystickName((int)jid);
    }

    @Override
    public void update() {
        FloatBuffer axesBuf = GLFW.glfwGetJoystickAxes((int)this.jid);
        ByteBuffer buttonsBuf = GLFW.glfwGetJoystickButtons((int)this.jid);
        ByteBuffer hatsBuf = GLFW.glfwGetJoystickHats((int)this.jid);
        Validate.notNull((Object)axesBuf, (String)"Could not fetch axes state for joystick", (Object[])new Object[0]);
        Validate.notNull((Object)buttonsBuf, (String)"Could not fetch buttons state for joystick", (Object[])new Object[0]);
        Validate.notNull((Object)hatsBuf, (String)"Could not fetch hats state for joystick", (Object[])new Object[0]);
        int numAxes = axesBuf.limit();
        int numButtons = buttonsBuf.limit();
        int numHats = hatsBuf.limit();
        float[] axes = new float[numAxes];
        for (int i = 0; i < numAxes; ++i) {
            axes[i] = axesBuf.get(i);
        }
        boolean[] buttons = new boolean[numButtons];
        for (int i = 0; i < numButtons; ++i) {
            buttons[i] = buttonsBuf.get(i) == 1;
        }
        JoystickState.HatState[] hats = new JoystickState.HatState[numHats];
        for (int i = 0; i < numHats; ++i) {
            hats[i] = switch (hatsBuf.get(i)) {
                case 0 -> JoystickState.HatState.CENTERED;
                case 1 -> JoystickState.HatState.UP;
                case 2 -> JoystickState.HatState.RIGHT;
                case 4 -> JoystickState.HatState.DOWN;
                case 8 -> JoystickState.HatState.LEFT;
                case 3 -> JoystickState.HatState.RIGHT_UP;
                case 6 -> JoystickState.HatState.RIGHT_DOWN;
                case 9 -> JoystickState.HatState.LEFT_UP;
                case 12 -> JoystickState.HatState.LEFT_DOWN;
                default -> throw new IllegalStateException("Unexpected value: " + hatsBuf.get(i));
            };
        }
        this.state = new BasicJoystickState(buttons, axes, hats);
    }

    @Override
    public BasicJoystickState getBasicJoystickState() {
        return this.state;
    }

    @Override
    public int getNumAxes() {
        return 0;
    }

    @Override
    public int getNumButtons() {
        return 0;
    }

    @Override
    public int getNumHats() {
        return 0;
    }

    @Override
    public String getGUID() {
        return this.guid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBasicJoystickDetails() {
        return "GLFWjoy";
    }

    @Override
    public String getNameProviderDetails() {
        return "GLFWjoy";
    }

    @Override
    public String getGUIDProviderDetails() {
        return "GLFWjoy";
    }
}

