/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.joystick;

import com.google.common.collect.Sets;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.BatteryDriver;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.driver.GUIDProvider;
import dev.isxander.controlify.driver.GameControllerDBDriver;
import dev.isxander.controlify.driver.NameProviderDriver;
import dev.isxander.controlify.driver.RumbleDriver;
import dev.isxander.controlify.driver.SDL2NativesManager;
import dev.isxander.controlify.driver.joystick.BasicJoystickInputDriver;
import dev.isxander.controlify.driver.joystick.GLFWJoystickDriver;
import dev.isxander.controlify.driver.joystick.SDL2JoystickDriver;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.utils.Log;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public record JoystickDrivers(BasicJoystickInputDriver basicJoystickInputDriver, RumbleDriver rumbleDriver, BatteryDriver batteryDriver, GUIDProvider guidProviderDriver, NameProviderDriver nameProviderDriver) {
    public Set<Driver> getUniqueDrivers() {
        Set drivers = Sets.newIdentityHashSet();
        drivers.addAll(List.of(this.basicJoystickInputDriver, this.rumbleDriver, this.batteryDriver, this.guidProviderDriver, this.nameProviderDriver));
        return drivers;
    }

    public void printDrivers() {
        if (DebugProperties.PRINT_DRIVER) {
            Log.LOGGER.info("Drivers in use: Basic Input = '{}', Rumble = '{}', Battery = '{}', Name = '{}', GUID = '{}'", new Object[]{this.basicJoystickInputDriver.getBasicJoystickDetails(), this.rumbleDriver.getRumbleDetails(), this.batteryDriver.getBatteryDriverDetails(), this.nameProviderDriver.getNameProviderDetails(), this.guidProviderDriver.getGUIDProviderDetails()});
        }
    }

    public static JoystickDrivers forController(int jid, Optional<HIDDevice> hid) {
        GLFWJoystickDriver glfwDriver;
        NameProviderDriver basicJoystickInputDriver = glfwDriver = new GLFWJoystickDriver(jid);
        NameProviderDriver nameProviderDriver = glfwDriver;
        NameProviderDriver guidProviderDriver = glfwDriver;
        RumbleDriver rumbleDriver = RumbleDriver.UNSUPPORTED;
        BatteryDriver batteryDriver = BatteryDriver.UNSUPPORTED;
        if (SDL2NativesManager.isLoaded()) {
            SDL2JoystickDriver sdl2Driver = new SDL2JoystickDriver(jid);
            basicJoystickInputDriver = sdl2Driver;
            rumbleDriver = sdl2Driver;
            batteryDriver = sdl2Driver;
            guidProviderDriver = sdl2Driver;
        }
        if (GameControllerDBDriver.isSupported(guidProviderDriver.getGUID())) {
            nameProviderDriver = new GameControllerDBDriver(guidProviderDriver.getGUID());
        }
        return new JoystickDrivers((BasicJoystickInputDriver)((Object)basicJoystickInputDriver), rumbleDriver, batteryDriver, (GUIDProvider)((Object)guidProviderDriver), nameProviderDriver);
    }
}

