/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.joystick;

import dev.isxander.controlify.controller.BatteryLevel;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.driver.BatteryDriver;
import dev.isxander.controlify.driver.GUIDProvider;
import dev.isxander.controlify.driver.NameProviderDriver;
import dev.isxander.controlify.driver.RumbleDriver;
import dev.isxander.controlify.driver.joystick.BasicJoystickInputDriver;
import dev.isxander.controlify.driver.joystick.BasicJoystickState;
import dev.isxander.controlify.utils.Log;
import io.github.libsdl4j.api.error.SdlError;
import io.github.libsdl4j.api.joystick.SDL_Joystick;
import io.github.libsdl4j.api.joystick.SdlJoystick;
import net.minecraft.class_3532;

public class SDL2JoystickDriver
implements BasicJoystickInputDriver,
RumbleDriver,
BatteryDriver,
GUIDProvider,
NameProviderDriver {
    private final SDL_Joystick ptrJoystick;
    private BasicJoystickState state = BasicJoystickState.EMPTY;
    private final boolean isRumbleSupported;
    private final boolean isTriggerRumbleSupported;
    private final String guid;
    private final String name;
    private final int numAxes;
    private final int numButtons;
    private final int numHats;

    public SDL2JoystickDriver(int jid) {
        this.ptrJoystick = SdlJoystick.SDL_JoystickOpen((int)jid);
        if (this.ptrJoystick == null) {
            throw new IllegalStateException("Could not open joystick: " + SdlError.SDL_GetError());
        }
        this.guid = SdlJoystick.SDL_JoystickGetGUID((SDL_Joystick)this.ptrJoystick).toString();
        this.name = SdlJoystick.SDL_JoystickName((SDL_Joystick)this.ptrJoystick);
        this.isRumbleSupported = SdlJoystick.SDL_JoystickHasRumble((SDL_Joystick)this.ptrJoystick);
        this.isTriggerRumbleSupported = SdlJoystick.SDL_JoystickHasRumbleTriggers((SDL_Joystick)this.ptrJoystick);
        this.numAxes = SdlJoystick.SDL_JoystickNumAxes((SDL_Joystick)this.ptrJoystick);
        this.numButtons = SdlJoystick.SDL_JoystickNumButtons((SDL_Joystick)this.ptrJoystick);
        this.numHats = SdlJoystick.SDL_JoystickNumHats((SDL_Joystick)this.ptrJoystick);
    }

    @Override
    public void update() {
        SdlJoystick.SDL_JoystickUpdate();
        float[] axes = new float[this.numAxes];
        for (int i = 0; i < this.numAxes; ++i) {
            axes[i] = SDL2JoystickDriver.mapShortToFloat(SdlJoystick.SDL_JoystickGetAxis((SDL_Joystick)this.ptrJoystick, (int)i));
        }
        boolean[] buttons = new boolean[this.numButtons];
        for (int i = 0; i < this.numButtons; ++i) {
            buttons[i] = SdlJoystick.SDL_JoystickGetButton((SDL_Joystick)this.ptrJoystick, (int)i) == 1;
        }
        JoystickState.HatState[] hats = new JoystickState.HatState[this.numHats];
        for (int i = 0; i < this.numHats; ++i) {
            hats[i] = switch (SdlJoystick.SDL_JoystickGetHat((SDL_Joystick)this.ptrJoystick, (int)i)) {
                case 0 -> JoystickState.HatState.CENTERED;
                case 1 -> JoystickState.HatState.UP;
                case 2 -> JoystickState.HatState.RIGHT;
                case 4 -> JoystickState.HatState.DOWN;
                case 8 -> JoystickState.HatState.LEFT;
                case 3 -> JoystickState.HatState.RIGHT_UP;
                case 6 -> JoystickState.HatState.RIGHT_DOWN;
                case 9 -> JoystickState.HatState.LEFT_UP;
                case 12 -> JoystickState.HatState.LEFT_DOWN;
                default -> throw new IllegalStateException("Unexpected value: " + SdlJoystick.SDL_JoystickGetHat((SDL_Joystick)this.ptrJoystick, (int)i));
            };
        }
        this.state = new BasicJoystickState(buttons, axes, hats);
    }

    @Override
    public int getNumAxes() {
        return this.numAxes;
    }

    @Override
    public int getNumButtons() {
        return this.numButtons;
    }

    @Override
    public int getNumHats() {
        return this.numHats;
    }

    @Override
    public BasicJoystickState getBasicJoystickState() {
        return this.state;
    }

    @Override
    public boolean rumble(float strongMagnitude, float weakMagnitude) {
        if (!this.isRumbleSupported()) {
            return false;
        }
        if (SdlJoystick.SDL_JoystickRumble((SDL_Joystick)this.ptrJoystick, (short)((short)(strongMagnitude * 65535.0f)), (short)((short)(weakMagnitude * 65535.0f)), (int)0) != 0) {
            Log.LOGGER.error("Could not rumble controller: " + SdlError.SDL_GetError());
            return false;
        }
        return true;
    }

    @Override
    public boolean rumbleTrigger(float left, float right) {
        if (!this.isTriggerRumbleSupported()) {
            return false;
        }
        if (SdlJoystick.SDL_JoystickRumbleTriggers((SDL_Joystick)this.ptrJoystick, (short)((short)(left * 65535.0f)), (short)((short)(right * 65535.0f)), (int)0) != 0) {
            Log.LOGGER.error("Could not rumble controller trigger: " + SdlError.SDL_GetError());
            return false;
        }
        return true;
    }

    @Override
    public BatteryLevel getBatteryLevel() {
        int powerLevel = SdlJoystick.SDL_JoystickCurrentPowerLevel((SDL_Joystick)this.ptrJoystick);
        return switch (powerLevel) {
            case -1 -> BatteryLevel.UNKNOWN;
            case 0 -> BatteryLevel.EMPTY;
            case 1 -> BatteryLevel.LOW;
            case 2 -> BatteryLevel.MEDIUM;
            case 3 -> BatteryLevel.FULL;
            case 4 -> BatteryLevel.WIRED;
            case 5 -> BatteryLevel.MAX;
            default -> throw new IllegalStateException("Unexpected value: " + powerLevel);
        };
    }

    @Override
    public boolean isRumbleSupported() {
        return this.isRumbleSupported;
    }

    @Override
    public boolean isTriggerRumbleSupported() {
        return this.isTriggerRumbleSupported;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGUID() {
        return this.guid;
    }

    @Override
    public String getBasicJoystickDetails() {
        return "SDL2joy axes=" + this.numAxes + " buttons=" + this.numButtons + " hats=" + this.numHats;
    }

    @Override
    public String getRumbleDetails() {
        return "SDL2joy supported=" + this.isRumbleSupported() + " trigger=" + this.isTriggerRumbleSupported();
    }

    @Override
    public String getGUIDProviderDetails() {
        return "SDL2joy";
    }

    @Override
    public String getBatteryDriverDetails() {
        return "SDL2joy";
    }

    @Override
    public String getNameProviderDetails() {
        return "SDL2joy";
    }

    @Override
    public void close() {
        SdlJoystick.SDL_JoystickClose((SDL_Joystick)this.ptrJoystick);
    }

    private static float mapShortToFloat(short value) {
        return class_3532.method_37958((float)value, (float)-32768.0f, (float)0.0f, (float)-1.0f, (float)0.0f) + class_3532.method_37958((float)value, (float)0.0f, (float)32767.0f, (float)0.0f, (float)1.0f);
    }
}

