/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.guide;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.ControllerBinding;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.api.guide.ActionPriority;
import dev.isxander.controlify.api.guide.GuideActionNameSupplier;
import dev.isxander.controlify.api.ingameguide.ActionLocation;
import dev.isxander.controlify.api.ingameguide.IngameGuideContext;
import dev.isxander.controlify.api.ingameguide.IngameGuideRegistry;
import dev.isxander.controlify.compatibility.ControlifyCompat;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.guide.GuideActionRenderer;
import dev.isxander.controlify.gui.layout.AnchorPoint;
import dev.isxander.controlify.gui.layout.ColumnLayoutComponent;
import dev.isxander.controlify.gui.layout.PositionedComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1675;
import net.minecraft.class_1770;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import net.minecraft.class_8251;
import org.joml.Matrix4f;

public class InGameButtonGuide
implements IngameGuideRegistry {
    private final Controller<?, ?> controller;
    private final class_746 player;
    private final class_310 minecraft = class_310.method_1551();
    private final List<GuideAction<IngameGuideContext>> leftGuides = new ArrayList<GuideAction<IngameGuideContext>>();
    private final List<GuideAction<IngameGuideContext>> rightGuides = new ArrayList<GuideAction<IngameGuideContext>>();
    private PositionedComponent<ColumnLayoutComponent<GuideActionRenderer<IngameGuideContext>>> leftLayout;
    private PositionedComponent<ColumnLayoutComponent<GuideActionRenderer<IngameGuideContext>>> rightLayout;

    public InGameButtonGuide(Controller<?, ?> controller, class_746 localPlayer) {
        this.controller = controller;
        this.player = localPlayer;
        this.registerDefaultActions();
        ((ControlifyEvents.IngameGuideRegistryEvent)ControlifyEvents.INGAME_GUIDE_REGISTRY.invoker()).onRegisterIngameGuide(controller.bindings(), this);
        Collections.sort(this.leftGuides);
        Collections.sort(this.rightGuides);
        this.refreshLayout();
    }

    public void refreshLayout() {
        boolean bottom = ((ControllerConfig)this.controller.config()).ingameGuideBottom;
        this.leftLayout = new PositionedComponent<ColumnLayoutComponent<GuideActionRenderer>>(ColumnLayoutComponent.builder().spacing(1).colPadding(2, 2).elementPosition(ColumnLayoutComponent.ElementPosition.LEFT).elements((Collection<GuideActionRenderer>)this.leftGuides.stream().map(guide -> new GuideActionRenderer(guide, false, true)).toList()).build(), !bottom ? AnchorPoint.TOP_LEFT : AnchorPoint.BOTTOM_LEFT, 0, 0, !bottom ? AnchorPoint.TOP_LEFT : AnchorPoint.BOTTOM_LEFT);
        this.rightLayout = new PositionedComponent<ColumnLayoutComponent<GuideActionRenderer>>(ColumnLayoutComponent.builder().spacing(1).colPadding(2, 2).elementPosition(ColumnLayoutComponent.ElementPosition.RIGHT).elements((Collection<GuideActionRenderer>)this.rightGuides.stream().map(guide -> new GuideActionRenderer(guide, true, true)).toList()).build(), !bottom ? AnchorPoint.TOP_RIGHT : AnchorPoint.BOTTOM_RIGHT, 0, 0, !bottom ? AnchorPoint.TOP_RIGHT : AnchorPoint.BOTTOM_RIGHT);
    }

    public void renderHud(class_332 graphics, float tickDelta, int width, int height) {
        if (!((ControllerConfig)this.controller.config()).showIngameGuide || this.minecraft.field_1755 != null || this.minecraft.field_1705.method_53531().method_53536()) {
            return;
        }
        float scale = Controlify.instance().config().globalSettings().ingameButtonGuideScale;
        boolean customScale = scale != 1.0f;
        Matrix4f prevProjection = null;
        if (customScale) {
            prevProjection = RenderSystem.getProjectionMatrix();
            double guiScale = this.minecraft.method_22683().method_4495() * (double)scale;
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)this.minecraft.method_22683().method_4489() / guiScale), (float)((double)this.minecraft.method_22683().method_4506() / guiScale), 0.0f, 1000.0f, 21000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
        }
        ControlifyCompat.ifBeginHudBatching();
        this.leftLayout.renderComponent(graphics, tickDelta);
        this.rightLayout.renderComponent(graphics, tickDelta);
        ControlifyCompat.ifEndHudBatching();
        if (customScale) {
            RenderSystem.setProjectionMatrix((Matrix4f)prevProjection, (class_8251)class_8251.field_43361);
        }
    }

    public void tick() {
        IngameGuideContext context = new IngameGuideContext(class_310.method_1551(), this.player, this.minecraft.field_1687, this.calculateHitResult(), this.controller);
        this.leftLayout.getComponent().getChildComponents().forEach(renderer -> renderer.updateName(context));
        this.rightLayout.getComponent().getChildComponents().forEach(renderer -> renderer.updateName(context));
        double guiScale = this.minecraft.method_22683().method_4495() * (double)Controlify.instance().config().globalSettings().ingameButtonGuideScale;
        int width = (int)((double)this.minecraft.method_22683().method_4489() / guiScale);
        int height = (int)((double)this.minecraft.method_22683().method_4506() / guiScale);
        this.leftLayout.updatePosition(width, height);
        this.rightLayout.updatePosition(width, height);
    }

    @Override
    public void registerGuideAction(ControllerBinding binding, ActionLocation location, GuideActionNameSupplier<IngameGuideContext> supplier) {
        this.registerGuideAction(binding, location, ActionPriority.NORMAL, supplier);
    }

    @Override
    public void registerGuideAction(ControllerBinding binding, ActionLocation location, ActionPriority priority, GuideActionNameSupplier<IngameGuideContext> supplier) {
        if (location == ActionLocation.LEFT) {
            this.leftGuides.add(new GuideAction<IngameGuideContext>(binding, supplier, priority));
        } else {
            this.rightGuides.add(new GuideAction<IngameGuideContext>(binding, supplier, priority));
        }
    }

    private void registerDefaultActions() {
        class_315 options = class_310.method_1551().field_1690;
        this.registerGuideAction(this.controller.bindings().JUMP, ActionLocation.LEFT, ctx -> {
            class_1799 chestStack;
            class_746 player = ctx.player();
            if (player.method_31549().field_7479) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.fly_up"));
            }
            if (player.method_24828()) {
                return Optional.of(class_2561.method_43471((String)"key.jump"));
            }
            if (player.method_5799()) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.swim_up"));
            }
            if (!player.method_24828() && !player.method_6128() && !player.method_5799() && !player.method_6059(class_1294.field_5902) && (chestStack = player.method_6118(class_1304.field_6174)).method_31574(class_1802.field_8833) && class_1770.method_7804((class_1799)chestStack)) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.start_elytra"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().SNEAK, ActionLocation.LEFT, ctx -> {
            class_746 player = ctx.player();
            if (player.method_5854() != null) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.dismount"));
            }
            if (player.method_31549().field_7479) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.fly_down"));
            }
            if (player.method_5799() && !player.method_24828()) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.swim_down"));
            }
            if (((ControllerConfig)ctx.controller().config()).toggleSneak) {
                return Optional.of(class_2561.method_43471((String)(player.field_3913.field_3903 ? "controlify.guide.ingame.stop_sneaking" : "controlify.guide.ingame.start_sneaking")));
            }
            if (!player.field_3913.field_3903) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.sneak"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().SPRINT, ActionLocation.LEFT, ctx -> {
            class_746 player = ctx.player();
            if (!options.field_1867.method_1434()) {
                if (!player.field_3913.method_3128().method_1016(class_241.field_1340)) {
                    if (player.method_5869()) {
                        return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.start_swimming"));
                    }
                    return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.start_sprinting"));
                }
            } else if (((ControllerConfig)ctx.controller().config()).toggleSprint) {
                if (player.method_5869()) {
                    return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.stop_swimming"));
                }
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.stop_sprinting"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().INVENTORY, ActionLocation.RIGHT, ctx -> {
            if (ctx.client().field_1755 == null) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.inventory"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().RADIAL_MENU, ActionLocation.RIGHT, ctx -> {
            if (ctx.client().field_1755 == null) {
                return Optional.of(class_2561.method_43471((String)"controlify.gui.radial_menu"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().ATTACK, ActionLocation.RIGHT, ctx -> {
            class_239 hitResult = ctx.hitResult();
            if (hitResult.method_17783() == class_239.class_240.field_1331) {
                if (this.player.method_7325()) {
                    return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.spectate"));
                }
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.attack"));
            }
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.break"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().USE, ActionLocation.RIGHT, ctx -> {
            class_239 hitResult = ctx.hitResult();
            class_746 player = ctx.player();
            if (hitResult.method_17783() == class_239.class_240.field_1331) {
                if (player.method_7325()) {
                    return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.spectate"));
                }
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.interact"));
            }
            if (hitResult.method_17783() == class_239.class_240.field_1332 || player.method_6084(class_1304.field_6173) || player.method_6084(class_1304.field_6171)) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.use"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().DROP_INGAME, ActionLocation.RIGHT, ctx -> {
            class_1799 holdingItem = ctx.player().method_31548().method_7391();
            if (!holdingItem.method_7960()) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.drop"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().DROP_STACK, ActionLocation.RIGHT, ctx -> {
            class_1799 holdingItem = ctx.player().method_31548().method_7391();
            if (!holdingItem.method_7960() && holdingItem.method_7947() > 1) {
                return Optional.of(class_2561.method_43471((String)"controlify.binding.controlify.drop_stack"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().SWAP_HANDS, ActionLocation.RIGHT, ctx -> {
            class_746 player = ctx.player();
            if (player.method_6084(class_1304.field_6173) || player.method_6084(class_1304.field_6171)) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.swap_hands"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().PICK_BLOCK, ActionLocation.RIGHT, ctx -> {
            if (ctx.hitResult().method_17783() == class_239.class_240.field_1332 && ctx.player().method_7337()) {
                return Optional.of(class_2561.method_43471((String)"controlify.guide.ingame.pick_block"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(this.controller.bindings().PICK_BLOCK_NBT, ActionLocation.RIGHT, ctx -> {
            if (ctx.hitResult().method_17783() == class_239.class_240.field_1332 && ctx.player().method_7337()) {
                return Optional.of(class_2561.method_43471((String)"controlify.binding.controlify.pick_block_nbt"));
            }
            return Optional.empty();
        });
    }

    private class_239 calculateHitResult() {
        class_238 box;
        double pickRange = this.minecraft.field_1761.method_2904();
        class_239 pickResult = this.player.method_5745(pickRange, 1.0f, false);
        class_243 eyePos = this.player.method_5836(1.0f);
        if (this.minecraft.field_1761.method_2926()) {
            pickRange = 6.0;
        }
        double maxPickRange = pickResult.method_17784().method_1025(eyePos);
        class_243 viewVec = this.player.method_5828(1.0f);
        class_243 reachVec = eyePos.method_1031(viewVec.field_1352 * pickRange, viewVec.field_1351 * pickRange, viewVec.field_1350 * pickRange);
        class_3966 entityHitResult = class_1675.method_18075((class_1297)this.player, (class_243)eyePos, (class_243)reachVec, (class_238)(box = this.player.method_5829().method_18804(viewVec.method_1021(pickRange)).method_1009(1.0, 1.0, 1.0)), entity -> !entity.method_7325() && entity.method_5863(), (double)maxPickRange);
        if (entityHitResult != null && entityHitResult.method_17784().method_1025(eyePos) < pickResult.method_17784().method_1025(eyePos)) {
            return entityHitResult;
        }
        return pickResult;
    }
}

