/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.gamepademulated.EmulatedGamepadConfig;
import dev.isxander.controlify.controller.gamepademulated.EmulatedGamepadController;
import dev.isxander.controlify.controller.gamepademulated.mapping.AxisMapping;
import dev.isxander.controlify.controller.gamepademulated.mapping.ButtonMapping;
import dev.isxander.controlify.controller.gamepademulated.mapping.UserGamepadMapping;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.driver.joystick.BasicJoystickState;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.ClientUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class GamepadEmulationMappingCreatorScreen
extends class_437
implements ScreenControllerEventListener,
ScreenProcessorProvider,
DontInteruptScreen {
    private final EmulatedGamepadController controller;
    private final UserGamepadMapping.Builder mappingBuilder = new UserGamepadMapping.Builder();
    private final ScreenProcessor<GamepadEmulationMappingCreatorScreen> screenProcessor = new ScreenProcessorImpl(this);
    private int delayTillNextStage = 20;
    private final List<Stage> STAGES;
    private Stage currentStage;
    private class_4185 goBackButton;
    private final class_437 lastScreen;

    public GamepadEmulationMappingCreatorScreen(EmulatedGamepadController controller, class_437 lastScreen) {
        super((class_2561)class_2561.method_43470((String)"Gamepad Emulation Mapping Creator"));
        Stage[] stageArray = new Stage[20];
        stageArray[0] = new ButtonStage(this.mappingBuilder::faceDownButton, GamepadEmulationMappingCreatorScreen.button("face_down"), "face_down", "faceview");
        stageArray[1] = new ButtonStage(this.mappingBuilder::faceLeftButton, GamepadEmulationMappingCreatorScreen.button("face_left"), "face_left", "faceview");
        stageArray[2] = new ButtonStage(this.mappingBuilder::faceRightButton, GamepadEmulationMappingCreatorScreen.button("face_right"), "face_right", "faceview");
        stageArray[3] = new ButtonStage(this.mappingBuilder::faceUpButton, GamepadEmulationMappingCreatorScreen.button("face_up"), "face_up", "faceview");
        stageArray[4] = new ButtonStage(this.mappingBuilder::leftBumper, GamepadEmulationMappingCreatorScreen.button("left_bumper"), "left_bumper", "triggerview");
        stageArray[5] = new ButtonStage(this.mappingBuilder::rightBumper, GamepadEmulationMappingCreatorScreen.button("right_bumper"), "right_bumper", "triggerview");
        stageArray[6] = new ButtonStage(this.mappingBuilder::leftSpecial, GamepadEmulationMappingCreatorScreen.button("left_special"), "left_special", "faceview");
        stageArray[7] = new ButtonStage(this.mappingBuilder::rightSpecial, GamepadEmulationMappingCreatorScreen.button("right_special"), "right_special", "faceview");
        stageArray[8] = new ButtonStage(this.mappingBuilder::leftStickDown, GamepadEmulationMappingCreatorScreen.button("left_stick_down"), "left_stick_press", "faceview");
        stageArray[9] = new ButtonStage(this.mappingBuilder::rightStickDown, GamepadEmulationMappingCreatorScreen.button("right_stick_down"), "right_stick_press", "faceview");
        stageArray[10] = new ButtonStage(this.mappingBuilder::dpadUp, GamepadEmulationMappingCreatorScreen.button("dpad_up"), "dpad_up", "faceview");
        stageArray[11] = new ButtonStage(this.mappingBuilder::dpadLeft, GamepadEmulationMappingCreatorScreen.button("dpad_left"), "dpad_left", "faceview");
        stageArray[12] = new ButtonStage(this.mappingBuilder::dpadDown, GamepadEmulationMappingCreatorScreen.button("dpad_down"), "dpad_down", "faceview");
        stageArray[13] = new ButtonStage(this.mappingBuilder::dpadRight, GamepadEmulationMappingCreatorScreen.button("dpad_right"), "dpad_right", "faceview");
        stageArray[14] = new AxisStage(this.mappingBuilder::leftStickX, GamepadEmulationMappingCreatorScreen.axis("left_stick", true), "left_stick_x", "faceview");
        stageArray[15] = new AxisStage(this.mappingBuilder::leftStickY, GamepadEmulationMappingCreatorScreen.axis("left_stick", false), "left_stick_y", "faceview");
        stageArray[16] = new AxisStage(this.mappingBuilder::rightStickX, GamepadEmulationMappingCreatorScreen.axis("right_stick", true), "right_stick_x", "faceview");
        stageArray[17] = new AxisStage(this.mappingBuilder::rightStickY, GamepadEmulationMappingCreatorScreen.axis("right_stick", false), "right_stick_y", "faceview");
        stageArray[18] = new TriggerAxisStage(this.mappingBuilder::triggerLeft, (class_2561)class_2561.method_43471((String)"controlify.gui.gamepademulationmappingcreator.instruction.left_trigger"), "left_trigger", "triggerview");
        stageArray[19] = new TriggerAxisStage(this.mappingBuilder::triggerRight, (class_2561)class_2561.method_43471((String)"controlify.gui.gamepademulationmappingcreator.instruction.right_trigger"), "right_trigger", "triggerview");
        this.STAGES = List.of(stageArray);
        this.currentStage = null;
        this.controller = controller;
        this.lastScreen = lastScreen;
        this.mappingBuilder.inputDriverName(controller.drivers.basicJoystickInputDriver().getBasicJoystickDetails());
        ((EmulatedGamepadConfig)controller.config()).mapping = UserGamepadMapping.NO_MAPPING;
    }

    protected void method_25426() {
        this.goBackButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"controlify.gui.gamepademulationmappingcreator.go_back"), button -> this.goBackStage()).method_46434(this.field_22789 / 2 - 152, this.field_22790 - 60, 150, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"controlify.gui.gamepademulationmappingcreator.go_back.tooltip"))).method_46431();
        this.method_37063((class_364)this.goBackButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"controlify.gui.gamepademulationmappingcreator.no_map"), button -> this.mapAsNone()).method_46434(this.field_22789 / 2 + 2, this.field_22790 - 60, 150, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"controlify.gui.gamepademulationmappingcreator.no_map.tooltip"))).method_46431());
        this.goBackButton.field_22763 = false;
    }

    public void method_25393() {
        if (this.delayTillNextStage >= 0) {
            --this.delayTillNextStage;
            if (this.delayTillNextStage == -1) {
                if (this.currentStage == null) {
                    this.setStage(this.STAGES.get(0));
                } else {
                    int index = this.STAGES.indexOf(this.currentStage);
                    int nextIndex = index + 1;
                    if (nextIndex >= this.STAGES.size()) {
                        this.method_25419();
                    } else {
                        this.setStage(this.STAGES.get(index + 1));
                        this.goBackButton.field_22763 = true;
                    }
                }
            }
        } else {
            if (this.currentStage == null) {
                this.setStage(this.STAGES.get(0));
            } else if (this.currentStage.isSatisfied() && this.delayTillNextStage == -1) {
                this.delayTillNextStage = 20;
            }
            if (this.currentStage != null && !this.currentStage.isSatisfied()) {
                BasicJoystickState stateNow = this.controller.joyState();
                BasicJoystickState statePrev = this.controller.prevJoyState();
                Stage stage = this.currentStage;
                if (stage instanceof ButtonStage) {
                    ButtonStage buttonStage = (ButtonStage)stage;
                    this.processButtonStage(buttonStage, stateNow, statePrev);
                } else {
                    stage = this.currentStage;
                    if (stage instanceof AxisStage) {
                        AxisStage axisStage = (AxisStage)stage;
                        this.processAxisStage(axisStage, stateNow, statePrev);
                    }
                }
            }
        }
    }

    private void processButtonStage(ButtonStage buttonStage, BasicJoystickState stateNow, BasicJoystickState statePrev) {
        int i;
        for (i = 0; i < Math.min(stateNow.buttons().length, statePrev.buttons().length); ++i) {
            boolean prev;
            boolean now = stateNow.buttons()[i];
            if (now == (prev = statePrev.buttons()[i])) continue;
            ButtonMapping.FromButton mapping = new ButtonMapping.FromButton(i, !now);
            buttonStage.setMapping(mapping);
            return;
        }
        for (i = 0; i < Math.min(stateNow.axes().length, statePrev.axes().length); ++i) {
            float now = stateNow.axes()[i];
            float prev = statePrev.axes()[i];
            float diff = prev - now;
            if (!(Math.abs(diff) > 0.3f)) continue;
            ButtonMapping.FromAxis mapping = new ButtonMapping.FromAxis(i, diff > 0.0f ? ButtonMapping.FromAxis.NORMAL : ButtonMapping.FromAxis.INVERTED);
            buttonStage.setMapping(mapping);
            return;
        }
        for (i = 0; i < Math.min(stateNow.hats().length, statePrev.hats().length); ++i) {
            JoystickState.HatState prev;
            JoystickState.HatState now = stateNow.hats()[i];
            if (now == (prev = statePrev.hats()[i])) continue;
            ButtonMapping.FromHat mapping = new ButtonMapping.FromHat(i, now, false);
            buttonStage.setMapping(mapping);
            return;
        }
    }

    private void processAxisStage(AxisStage axisStage, BasicJoystickState stateNow, BasicJoystickState statePrev) {
        int i;
        for (i = 0; i < Math.min(stateNow.buttons().length, statePrev.buttons().length); ++i) {
            boolean prev;
            boolean now = stateNow.buttons()[i];
            if (now == (prev = statePrev.buttons()[i])) continue;
            AxisMapping.FromButton mapping = new AxisMapping.FromButton(i, prev ? 1.0f : 0.0f, now ? 1.0f : 0.0f);
            axisStage.setMapping(mapping);
            return;
        }
        for (i = 0; i < Math.min(stateNow.axes().length, statePrev.axes().length); ++i) {
            float now = stateNow.axes()[i];
            float prev = statePrev.axes()[i];
            float diff = prev - now;
            if (!(Math.abs(diff) > 0.3f)) continue;
            boolean isTrigger = axisStage instanceof TriggerAxisStage && prev < -0.5f;
            AxisMapping.FromAxis mapping = new AxisMapping.FromAxis(i, -1.0f, 1.0f, isTrigger ? 0.0f : -1.0f, 1.0f);
            axisStage.setMapping(mapping);
            return;
        }
        for (i = 0; i < Math.min(stateNow.hats().length, statePrev.hats().length); ++i) {
            JoystickState.HatState prev;
            JoystickState.HatState now = stateNow.hats()[i];
            if (now == (prev = statePrev.hats()[i])) continue;
            AxisMapping.FromHat mapping = new AxisMapping.FromHat(i, prev, 0.0f, 1.0f);
            axisStage.setMapping(mapping);
            return;
        }
    }

    private void setStage(Stage stage) {
        this.currentStage = stage;
    }

    private void mapAsNone() {
        Stage stage = this.currentStage;
        if (stage instanceof ButtonStage) {
            ButtonStage stage2 = (ButtonStage)stage;
            stage2.setMapping(new ButtonMapping.FromNothing(false));
        } else {
            stage = this.currentStage;
            if (stage instanceof AxisStage) {
                AxisStage stage3 = (AxisStage)stage;
                stage3.setMapping(new AxisMapping.FromNothing(0.0f));
            }
        }
        this.delayTillNextStage = 0;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
        ((EmulatedGamepadConfig)this.controller.config()).mapping = this.mappingBuilder.build();
        Controlify.instance().config().save();
    }

    private void goBackStage() {
        int index = this.STAGES.indexOf(this.currentStage);
        int nextIndex = index - 1;
        if (nextIndex >= 0) {
            this.setStage(this.STAGES.get(index - 1));
            this.currentStage.unsatisfy();
        }
        this.goBackButton.field_22763 = nextIndex > 0;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"controlify.gui.gamepademulationmappingcreator.title"), this.field_22789 / 2, 15, 0xFFFFFF);
        guiGraphics.method_27534(this.field_22793, (class_2561)(this.currentStage == null ? class_2561.method_43471((String)"controlify.gui.gamepademulationmappingcreator.please_wait") : this.currentStage.name()), this.field_22789 / 2, this.field_22790 - 20, 0xFFFFFF);
        int safeZone = Math.min(this.field_22789, this.field_22790) - 30;
        float scale = (float)safeZone / 32.0f;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, -5.0f, 0.0f);
        guiGraphics.method_51448().method_46416(-32.0f * scale / 2.0f, 0.0f, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        float colour = this.currentStage != null && this.currentStage.isSatisfied() ? 0.46f : 1.0f;
        guiGraphics.method_51422(colour, colour, colour, 1.0f);
        if (this.currentStage != null && this.currentStage.backgroundTexture() != null) {
            guiGraphics.method_25290(this.currentStage.backgroundTexture(), 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        if (this.currentStage == null || !this.currentStage.isSatisfied()) {
            class_2960 texture = this.currentStage != null ? this.currentStage.foregroundTexture() : new class_2960("controlify", "textures/gui/controllerdiagram/faceview.png");
            guiGraphics.method_25290(texture, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.method_51448().method_22909();
        float progress = this.currentStage != null ? (float)(this.STAGES.indexOf(this.currentStage) + 1) / (float)this.STAGES.size() : 0.0f;
        ClientUtils.drawBar(guiGraphics, this.field_22789 / 2, this.field_22790 - 30, progress);
    }

    private static class_2561 button(String buttonName) {
        return class_2561.method_43469((String)"controlify.gui.gamepademulationmappingcreator.instruction.button", (Object[])new Object[]{class_2561.method_43471((String)("controlify.gui.gamepademulationmappingcreator.instruction." + buttonName))});
    }

    private static class_2561 axis(String axisName, boolean horizontal) {
        class_5250 axis = class_2561.method_43471((String)("controlify.gui.gamepademulationmappingcreator.instruction." + axisName));
        return horizontal ? class_2561.method_43469((String)"controlify.gui.gamepademulationmappingcreator.instruction.axis_x", (Object[])new Object[]{axis}) : class_2561.method_43469((String)"controlify.gui.gamepademulationmappingcreator.instruction.axis_y", (Object[])new Object[]{axis});
    }

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.screenProcessor;
    }

    private static class ScreenProcessorImpl
    extends ScreenProcessor<GamepadEmulationMappingCreatorScreen> {
        public ScreenProcessorImpl(GamepadEmulationMappingCreatorScreen screen) {
            super(screen);
        }

        @Override
        public void onControllerUpdate(Controller<?, ?> controller) {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class Stage {
        private final class_2561 name;
        private final class_2960 foregroundTexture;
        private final class_2960 backgroundTexture;
        protected boolean satisfied;

        protected Stage(class_2561 name, String foreground, String background) {
            this.name = name;
            this.foregroundTexture = new class_2960("controlify", "textures/gui/controllerdiagram/" + foreground + ".png");
            this.backgroundTexture = new class_2960("controlify", "textures/gui/controllerdiagram/" + background + ".png");
        }

        public class_2561 name() {
            return this.name;
        }

        public class_2960 foregroundTexture() {
            return this.foregroundTexture;
        }

        public class_2960 backgroundTexture() {
            return this.backgroundTexture;
        }

        public boolean isSatisfied() {
            return this.satisfied;
        }

        public void unsatisfy() {
            this.satisfied = false;
        }
    }

    private static final class ButtonStage
    extends Stage {
        private final Function<ButtonMapping, UserGamepadMapping.Builder> builder;

        private ButtonStage(Function<ButtonMapping, UserGamepadMapping.Builder> builder, class_2561 name, String foreground, String background) {
            super(name, foreground, background);
            this.builder = builder;
        }

        public void setMapping(ButtonMapping mapping) {
            this.builder.apply(mapping);
            this.satisfied = true;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static class AxisStage
    extends Stage {
        private final Function<AxisMapping, UserGamepadMapping.Builder> builder;

        private AxisStage(Function<AxisMapping, UserGamepadMapping.Builder> builder, class_2561 name, String foreground, String background) {
            super(name, foreground, background);
            this.builder = builder;
        }

        public void setMapping(AxisMapping mapping) {
            this.builder.apply(mapping);
            this.satisfied = true;
        }
    }

    private static final class TriggerAxisStage
    extends AxisStage {
        private TriggerAxisStage(Function<AxisMapping, UserGamepadMapping.Builder> builder, class_2561 name, String foreground, String background) {
            super(builder, name, foreground, background);
        }
    }
}

