/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.ingame;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.api.ingameinput.LookInputModifier;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.controller.gamepad.GamepadConfig;
import dev.isxander.controlify.controller.gamepad.GamepadLike;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.gui.screen.RadialMenuScreen;
import dev.isxander.controlify.ingame.ControllerPlayerMovement;
import dev.isxander.controlify.ingame.PickBlockAccessor;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.utils.Animator;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.Easings;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1839;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_276;
import net.minecraft.class_2846;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5498;
import net.minecraft.class_746;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class InGameInputHandler {
    private final Controller<?, ?> controller;
    private final class_310 minecraft;
    private double lookInputX;
    private double lookInputY;
    private final GamepadState.GyroState gyroInput = new GamepadState.GyroState();
    private boolean wasAiming;
    private boolean shouldShowPlayerList;
    private final HoldRepeatHelper dropRepeatHelper;
    private boolean dropRepeating;

    public InGameInputHandler(Controller<?, ?> controller) {
        this.controller = controller;
        this.minecraft = class_310.method_1551();
        this.dropRepeatHelper = new HoldRepeatHelper(20, 1);
    }

    public void inputTick() {
        this.handlePlayerLookInput();
        this.handleKeybinds();
        this.preventFlyDrifting();
        ControllerPlayerMovement.ensureCorrectInput(this.minecraft.field_1724);
    }

    protected void handleKeybinds() {
        if (this.minecraft.field_1755 != null) {
            return;
        }
        if (this.controller.bindings().PAUSE.justPressed()) {
            this.minecraft.method_20539(false);
        }
        if (this.minecraft.field_1724 != null) {
            if (this.controller.bindings().NEXT_SLOT.justPressed()) {
                this.minecraft.field_1724.method_31548().method_7373(-1.0);
            }
            if (this.controller.bindings().PREV_SLOT.justPressed()) {
                this.minecraft.field_1724.method_31548().method_7373(1.0);
            }
            if (!this.minecraft.field_1724.method_7325()) {
                if (this.controller.bindings().DROP_STACK.justPressed()) {
                    if (this.minecraft.field_1724.method_7290(true)) {
                        this.minecraft.field_1724.method_6104(class_1268.field_5808);
                    }
                } else {
                    if (this.controller.bindings().DROP_INGAME.justPressed()) {
                        this.dropRepeating = true;
                    } else if (this.controller.bindings().DROP_INGAME.justReleased()) {
                        this.dropRepeating = false;
                    }
                    if (this.dropRepeating && this.dropRepeatHelper.shouldAction(this.controller.bindings().DROP_INGAME) && this.minecraft.field_1724.method_7290(false)) {
                        this.dropRepeatHelper.onNavigate();
                        this.minecraft.field_1724.method_6104(class_1268.field_5808);
                    }
                }
                if (this.controller.bindings().SWAP_HANDS.justPressed()) {
                    this.minecraft.field_1724.field_3944.method_52787((class_2596)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11033));
                }
            }
            if (this.controller.bindings().INVENTORY.justPressed()) {
                if (this.minecraft.field_1761.method_2895()) {
                    this.minecraft.field_1724.method_3132();
                } else {
                    this.minecraft.method_1577().method_4912();
                    this.minecraft.method_1507((class_437)new class_490((class_1657)this.minecraft.field_1724));
                }
            }
            if (this.controller.bindings().CHANGE_PERSPECTIVE.justPressed()) {
                class_5498 cameraType = this.minecraft.field_1690.method_31044();
                this.minecraft.field_1690.method_31043(this.minecraft.field_1690.method_31044().method_31036());
                if (cameraType.method_31034() != this.minecraft.field_1690.method_31044().method_31034()) {
                    this.minecraft.field_1773.method_3167(this.minecraft.field_1690.method_31044().method_31034() ? this.minecraft.method_1560() : null);
                }
                this.minecraft.field_1769.method_3292();
            }
        }
        if (this.controller.bindings().TOGGLE_HUD_VISIBILITY.justPressed()) {
            boolean bl = this.minecraft.field_1690.field_1842 = !this.minecraft.field_1690.field_1842;
        }
        if (this.controller.bindings().SHOW_PLAYER_LIST.justPressed()) {
            boolean bl = this.shouldShowPlayerList = !this.shouldShowPlayerList;
        }
        if (this.controller.bindings().TOGGLE_DEBUG_MENU.justPressed()) {
            this.minecraft.method_53526().method_53539();
        }
        if (this.controller.bindings().TAKE_SCREENSHOT.justPressed()) {
            class_318.method_1659((File)this.minecraft.field_1697, (class_276)this.minecraft.method_1522(), component -> this.minecraft.execute(() -> this.minecraft.field_1705.method_1743().method_1812(component)));
        }
        if (this.controller.bindings().PICK_BLOCK.justPressed()) {
            ((PickBlockAccessor)this.minecraft).controlify$pickBlock();
        }
        if (this.controller.bindings().PICK_BLOCK_NBT.justPressed()) {
            ((PickBlockAccessor)this.minecraft).controlify$pickBlockWithNbt();
        }
        if (this.controller.bindings().RADIAL_MENU.justPressed()) {
            this.minecraft.method_1507((class_437)new RadialMenuScreen(this.controller, false, null));
        }
    }

    protected void handlePlayerLookInput() {
        GamepadLike gamepad;
        class_746 player = this.minecraft.field_1724;
        GamepadLike gamepadLike = gamepad = this.controller instanceof GamepadLike ? (GamepadLike)this.controller : null;
        if (!this.minecraft.field_1729.method_1613() || !this.minecraft.method_1569() && !Controlify.instance().config().globalSettings().outOfFocusInput || this.minecraft.field_1755 != null || player == null) {
            this.lookInputX = 0.0;
            this.lookInputY = 0.0;
            return;
        }
        boolean isAiming = this.isAiming((class_1657)player);
        float impulseY = 0.0f;
        float impulseX = 0.0f;
        if (gamepad != null && ((GamepadConfig)gamepad.config()).flickStick) {
            float flick;
            float turnAngle = 600.0f;
            float f = this.controller.bindings().LOOK_DOWN.justPressed() || this.controller.bindings().LOOK_RIGHT.justPressed() ? 1.0f : (flick = this.controller.bindings().LOOK_UP.justPressed() || this.controller.bindings().LOOK_LEFT.justPressed() ? -1.0f : 0.0f);
            if (flick != 0.0f) {
                AtomicReference<Float> lastAngle = new AtomicReference<Float>(Float.valueOf(0.0f));
                Animator.INSTANCE.play(new Animator.AnimationInstance(10, Easings::easeOutExpo).addConsumer(angle -> {
                    player.method_5872((double)((angle.floatValue() - ((Float)lastAngle.get()).floatValue()) * flick), 0.0);
                    lastAngle.set((Float)angle);
                }, 0.0f, turnAngle));
            }
        } else {
            impulseY = this.controller.bindings().LOOK_DOWN.state() - this.controller.bindings().LOOK_UP.state();
            impulseX = this.controller.bindings().LOOK_RIGHT.state() - this.controller.bindings().LOOK_LEFT.state();
            Vector2f easedImpulse = ControllerUtils.applyEasingToLength(impulseX, impulseY, x -> Float.valueOf(x.floatValue() * Math.abs(x.floatValue())));
            impulseX = easedImpulse.x();
            impulseY = easedImpulse.y();
            impulseX *= ((ControllerConfig)this.controller.config()).horizontalLookSensitivity * 10.0f;
            impulseY *= ((ControllerConfig)this.controller.config()).verticalLookSensitivity * 10.0f;
            if (((ControllerConfig)this.controller.config()).reduceAimingSensitivity && player.method_6115()) {
                float aimMultiplier = switch (player.method_6030().method_7976()) {
                    case class_1839.field_8953, class_1839.field_8951 -> 0.6f;
                    case class_1839.field_27079 -> 0.2f;
                    default -> 1.0f;
                };
                impulseX *= aimMultiplier;
                impulseY *= aimMultiplier;
            }
        }
        if (gamepad != null && gamepad.supportsGyro()) {
            boolean useGyro = false;
            if (((GamepadConfig)gamepad.config()).gyroRequiresButton) {
                if (gamepad.bindings().GAMEPAD_GYRO_BUTTON.justPressed() || isAiming && !this.wasAiming) {
                    this.gyroInput.set(0.0f);
                }
                if (gamepad.bindings().GAMEPAD_GYRO_BUTTON.held() || isAiming) {
                    if (((GamepadConfig)gamepad.config()).relativeGyroMode) {
                        this.gyroInput.add((Vector3fc)new Vector3f((Vector3fc)((GamepadState)gamepad.state()).gyroDelta()).mul(0.1f));
                    } else {
                        this.gyroInput.set(((GamepadState)gamepad.state()).gyroDelta());
                    }
                    useGyro = true;
                }
            } else {
                this.gyroInput.set(((GamepadState)gamepad.state()).gyroDelta());
                useGyro = true;
            }
            if (useGyro) {
                GamepadState.GyroState thisInput = new GamepadState.GyroState(this.gyroInput).mul(57.295776f).div(20.0f).mul(((GamepadConfig)gamepad.config()).gyroLookSensitivity);
                impulseY += -thisInput.pitch() * (float)(((GamepadConfig)gamepad.config()).invertGyroY ? -1 : 1);
                impulseX += (-thisInput.roll() - thisInput.yaw()) * (float)(((GamepadConfig)gamepad.config()).invertGyroX ? -1 : 1);
            }
        }
        LookInputModifier lookInputModifier = (LookInputModifier)ControlifyEvents.LOOK_INPUT_MODIFIER.invoker();
        impulseX = lookInputModifier.modifyX(impulseX, this.controller);
        impulseY = lookInputModifier.modifyY(impulseY, this.controller);
        this.lookInputX = impulseX;
        this.lookInputY = impulseY;
        this.wasAiming = isAiming;
    }

    public void processPlayerLook(float deltaTime) {
        if (this.minecraft.field_1724 != null) {
            this.minecraft.field_1724.method_5872(this.lookInputX / (double)0.15f * (double)deltaTime, this.lookInputY / (double)0.15f * (double)deltaTime);
        }
    }

    public boolean shouldShowPlayerList() {
        return this.shouldShowPlayerList;
    }

    public void preventFlyDrifting() {
        if (!((ControllerConfig)this.controller.config()).disableFlyDrifting || !ServerPolicies.DISABLE_FLY_DRIFTING.get().isAllowed()) {
            return;
        }
        class_746 player = this.minecraft.field_1724;
        if (player != null && player.method_31549().field_7479 && !player.method_24828()) {
            class_243 motion = player.method_18798();
            double x = motion.field_1352;
            double y = motion.field_1351;
            double z = motion.field_1350;
            if (!player.field_3913.field_3904) {
                y = Math.min(y, 0.0);
            }
            if (!player.field_3913.field_3903) {
                y = Math.max(y, 0.0);
            }
            if (player.field_3913.field_3905 == 0.0f && player.field_3913.field_3907 == 0.0f) {
                x = 0.0;
                z = 0.0;
            }
            player.method_18800(x, y, z);
        }
    }

    private boolean isAiming(class_1657 player) {
        boolean bl;
        block4: {
            block3: {
                if (!player.method_6115()) break block3;
                switch (player.method_6030().method_7976()) {
                    case field_8953: 
                    case field_8951: 
                    case field_27079: 
                    case field_8947: {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public record FunctionalLookInputModifier(BiFunction<Float, Controller<?, ?>, Float> x, BiFunction<Float, Controller<?, ?>, Float> y) implements LookInputModifier
    {
        @Override
        public float modifyX(float x, Controller<?, ?> controller) {
            return this.x.apply(Float.valueOf(x), controller).floatValue();
        }

        @Override
        public float modifyY(float y, Controller<?, ?> controller) {
            return this.y.apply(Float.valueOf(y), controller).floatValue();
        }
    }
}

