/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.rumble;

import com.google.gson.JsonObject;
import dev.isxander.controlify.utils.Log;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_2960;

public record RumbleSource(class_2960 id) {
    private static final Map<class_2960, RumbleSource> SOURCES = new Object2ObjectLinkedOpenHashMap();
    public static final RumbleSource MASTER = RumbleSource.register("master");
    public static final RumbleSource DAMAGE = RumbleSource.register("damage");
    public static final RumbleSource BLOCK_DESTROY = RumbleSource.register("block_destroy");
    public static final RumbleSource USE_ITEM = RumbleSource.register("use_item");
    public static final RumbleSource ITEM_BREAK = RumbleSource.register("item_break");
    public static final RumbleSource GUI = RumbleSource.register("gui");
    public static final RumbleSource EXPLOSION = RumbleSource.register("explosion");
    public static final RumbleSource MISC = RumbleSource.register("misc");
    public static final RumbleSource GLOBAL_EVENT = RumbleSource.register("global_event");

    public static RumbleSource get(class_2960 id) {
        RumbleSource source = SOURCES.get(id);
        if (source == null) {
            Log.LOGGER.warn("Unknown rumble source: {}. Using master.", (Object)id);
            return MASTER;
        }
        return source;
    }

    public static Collection<RumbleSource> values() {
        return SOURCES.values();
    }

    public static JsonObject getDefaultJson() {
        JsonObject object = new JsonObject();
        for (RumbleSource source : SOURCES.values()) {
            object.addProperty(source.id().toString(), (Number)Float.valueOf(1.0f));
        }
        return object;
    }

    public static RumbleSource register(class_2960 id) {
        RumbleSource source = new RumbleSource(id);
        SOURCES.put(id, source);
        return source;
    }

    public static RumbleSource register(String identifier, String path) {
        return RumbleSource.register(new class_2960(identifier, path));
    }

    private static RumbleSource register(String path) {
        return RumbleSource.register("controlify", path);
    }
}

