/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.server;

import dev.isxander.controlify.rumble.BasicRumbleEffect;
import dev.isxander.controlify.rumble.RumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public record VibrationPacket(RumbleSource source, RumbleState[] frames) implements FabricPacket
{
    public static final PacketType<VibrationPacket> TYPE = PacketType.create((class_2960)new class_2960("controlify", "vibration"), VibrationPacket::new);

    public VibrationPacket(class_2540 buf) {
        this(RumbleSource.get(buf.method_10810()), VibrationPacket.readFrames(buf));
    }

    public void write(class_2540 buf) {
        buf.method_10812(this.source.id());
        int[] packedFrames = new int[this.frames.length];
        for (int i = 0; i < this.frames.length; ++i) {
            RumbleState frame = this.frames[i];
            int high = (int)(frame.strong() * 32767.0f);
            int low = (int)(frame.weak() * 32767.0f);
            packedFrames[i] = high << 16 | low & 0xFFFF;
        }
        buf.method_10806(packedFrames);
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    public RumbleEffect createEffect() {
        return new BasicRumbleEffect(this.frames).earlyFinish(() -> class_310.method_1551().field_1687 == null);
    }

    private static RumbleState[] readFrames(class_2540 buf) {
        int[] packedFrames = buf.method_10787();
        RumbleState[] frames = new RumbleState[packedFrames.length];
        for (int i = 0; i < packedFrames.length; ++i) {
            int packed = packedFrames[i];
            float strong = (float)((short)(packed >> 16)) / 32767.0f;
            float weak = (float)((short)packed) / 32767.0f;
            frames[i] = new RumbleState(strong, weak);
        }
        return frames;
    }
}

