/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_3532;

public final class Animator {
    public static final Animator INSTANCE = new Animator();
    private final List<AnimationInstance> animations = new ArrayList<AnimationInstance>();

    private Animator() {
    }

    public void progress(float deltaTime) {
        this.animations.forEach(animation -> animation.tick(deltaTime));
        this.animations.removeIf(AnimationInstance::isDone);
    }

    public AnimationInstance play(AnimationInstance animation) {
        this.animations.add(animation);
        return animation;
    }

    public static class AnimationInstance {
        private final List<AnimationConsumer> animations;
        private final UnaryOperator<Float> easingFunction;
        private final int durationTicks;
        private float time;
        private boolean done;
        private final List<Runnable> callbacks = new ArrayList<Runnable>();

        public AnimationInstance(int durationTicks, UnaryOperator<Float> easingFunction) {
            this.animations = new ArrayList<AnimationConsumer>();
            this.easingFunction = easingFunction;
            this.durationTicks = durationTicks;
        }

        public AnimationInstance addConsumer(Consumer<Float> consumer, float start, float end) {
            this.animations.add(new AnimationConsumer(consumer, start, end));
            return this;
        }

        public AnimationInstance addConsumer(Consumer<Integer> consumer, int start, int end) {
            this.animations.add(new AnimationConsumer(aFloat -> consumer.accept(aFloat.intValue()), start, end));
            return this;
        }

        public AnimationInstance onComplete(Runnable callback) {
            this.callbacks.add(callback);
            return this;
        }

        private void tick(float deltaTime) {
            this.time += deltaTime;
            if (this.time > (float)this.durationTicks) {
                if (!this.done) {
                    this.callbacks.removeIf(callback -> {
                        callback.run();
                        return true;
                    });
                }
                this.done = true;
                this.time = this.durationTicks;
            }
            this.updateConsumers();
        }

        private void updateConsumers() {
            this.animations.forEach(consumer -> {
                float progress = ((Float)this.easingFunction.apply(Float.valueOf(this.time / (float)this.durationTicks))).floatValue();
                float value = class_3532.method_16439((float)progress, (float)consumer.start, (float)consumer.end);
                consumer.consumer.accept(Float.valueOf(value));
            });
        }

        public void finish() {
            this.time = this.durationTicks;
            this.updateConsumers();
        }

        public boolean isDone() {
            return this.done;
        }

        private record AnimationConsumer(Consumer<Float> consumer, float start, float end) {
        }
    }
}

