/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.wireless;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.BatteryLevel;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.utils.ToastUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;

public class LowBatteryNotifier {
    private static final Map<String, BatteryLevel> previousBatteryLevels = new HashMap<String, BatteryLevel>();
    private static int interval;

    public static void tick() {
        if (interval > 0) {
            --interval;
            return;
        }
        interval = 1200;
        if (!Controlify.instance().config().globalSettings().notifyLowBattery) {
            return;
        }
        ControllerManager controllerManager = Controlify.instance().getControllerManager().orElse(null);
        if (controllerManager == null) {
            return;
        }
        for (Controller<?, ?> controller : controllerManager.getConnectedControllers()) {
            BatteryLevel batteryLevel = controller.batteryLevel();
            if (batteryLevel == BatteryLevel.UNKNOWN) continue;
            String uid = controller.uid();
            if (previousBatteryLevels.containsKey(uid)) {
                BatteryLevel previousBatteryLevel = previousBatteryLevels.get(uid);
                if (batteryLevel.ordinal() < previousBatteryLevel.ordinal() && batteryLevel == BatteryLevel.LOW) {
                    ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.low_battery.title"), (class_2561)class_2561.method_43469((String)"controlify.toast.low_battery.message", (Object[])new Object[]{controller.name()}), true);
                }
            }
            previousBatteryLevels.put(uid, batteryLevel);
        }
    }
}

