/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.shader_overrides;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.function.IntFunction;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.shader.uniform.GlUniform;
import me.jellysquid.mods.sodium.client.gl.shader.uniform.GlUniformBlock;
import me.jellysquid.mods.sodium.client.gl.shader.uniform.GlUniformFloat3v;
import me.jellysquid.mods.sodium.client.gl.shader.uniform.GlUniformMatrix4f;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ShaderBindingContext;
import me.jellysquid.mods.sodium.client.util.TextureUtil;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.GlUniformMatrix3f;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisShaderFogComponent;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ShaderBindingContextExt;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendOverride;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class IrisChunkShaderInterface
extends ChunkShaderInterface {
    @Nullable
    private final GlUniformMatrix4f uniformModelViewMatrix;
    @Nullable
    private final GlUniformMatrix4f uniformModelViewMatrixInverse;
    @Nullable
    private final GlUniformMatrix4f uniformProjectionMatrix;
    @Nullable
    private final GlUniformMatrix4f uniformProjectionMatrixInverse;
    @Nullable
    private final GlUniformFloat3v uniformRegionOffset;
    @Nullable
    private final GlUniformMatrix3f uniformNormalMatrix;
    @Nullable
    private final GlUniformBlock uniformBlockDrawParameters;
    private final BlendModeOverride blendModeOverride;
    private final IrisShaderFogComponent fogShaderComponent;
    private final float alpha;
    private final ProgramUniforms irisProgramUniforms;
    private final ProgramSamplers irisProgramSamplers;
    private final ProgramImages irisProgramImages;
    private final List<BufferBlendOverride> bufferBlendOverrides;
    private final boolean hasOverrides;
    private CustomUniforms customUniforms;

    public IrisChunkShaderInterface(int n, ShaderBindingContextExt shaderBindingContextExt, SodiumTerrainPipeline sodiumTerrainPipeline, ChunkShaderOptions chunkShaderOptions, boolean bl, BlendModeOverride blendModeOverride, List<BufferBlendOverride> list, float f, CustomUniforms customUniforms) {
        class Net_coderbot_iris_compat_sodium_impl_shader_overrides_IrisChunkShaderInterface$1
        implements ShaderBindingContext {
            final /* synthetic */ ShaderBindingContextExt val$contextExt;

            Net_coderbot_iris_compat_sodium_impl_shader_overrides_IrisChunkShaderInterface$1(ShaderBindingContextExt shaderBindingContextExt) {
                this.val$contextExt = shaderBindingContextExt;
            }

            public <U extends GlUniform<?>> U bindUniform(String string, IntFunction<U> intFunction) {
                return this.val$contextExt.bindUniformIfPresent(string, intFunction);
            }

            public GlUniformBlock bindUniformBlock(String string, int n) {
                return this.val$contextExt.bindUniformBlockIfPresent(string, n);
            }
        }
        super((ShaderBindingContext)new Net_coderbot_iris_compat_sodium_impl_shader_overrides_IrisChunkShaderInterface$1(shaderBindingContextExt), chunkShaderOptions);
        this.uniformModelViewMatrix = shaderBindingContextExt.bindUniformIfPresent("iris_ModelViewMatrix", GlUniformMatrix4f::new);
        this.uniformModelViewMatrixInverse = shaderBindingContextExt.bindUniformIfPresent("iris_ModelViewMatrixInverse", GlUniformMatrix4f::new);
        this.uniformProjectionMatrix = shaderBindingContextExt.bindUniformIfPresent("iris_ProjectionMatrix", GlUniformMatrix4f::new);
        this.uniformProjectionMatrixInverse = shaderBindingContextExt.bindUniformIfPresent("iris_ProjectionMatrixInverse", GlUniformMatrix4f::new);
        this.uniformRegionOffset = shaderBindingContextExt.bindUniformIfPresent("u_RegionOffset", GlUniformFloat3v::new);
        this.uniformNormalMatrix = shaderBindingContextExt.bindUniformIfPresent("iris_NormalMatrix", GlUniformMatrix3f::new);
        this.uniformBlockDrawParameters = shaderBindingContextExt.bindUniformBlockIfPresent("ubo_DrawParameters", 0);
        this.customUniforms = customUniforms;
        this.alpha = f;
        this.blendModeOverride = blendModeOverride;
        this.bufferBlendOverrides = list;
        this.hasOverrides = this.bufferBlendOverrides != null && !this.bufferBlendOverrides.isEmpty();
        this.fogShaderComponent = new IrisShaderFogComponent(shaderBindingContextExt);
        ProgramUniforms.Builder builder = sodiumTerrainPipeline.initUniforms(n);
        customUniforms.mapholderToPass(builder, (Object)this);
        this.irisProgramUniforms = builder.buildUniforms();
        this.irisProgramSamplers = bl ? sodiumTerrainPipeline.initShadowSamplers(n) : sodiumTerrainPipeline.initTerrainSamplers(n);
        this.irisProgramImages = bl ? sodiumTerrainPipeline.initShadowImages(n) : sodiumTerrainPipeline.initTerrainImages(n);
    }

    public void setupState() {
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 0, TextureUtil.getBlockTextureId());
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 2, TextureUtil.getLightTextureId());
        GlStateManager._activeTexture((int)33986);
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alpha);
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.hasOverrides) {
            this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
        }
        this.fogShaderComponent.setup();
        this.irisProgramUniforms.update();
        this.irisProgramSamplers.update();
        this.irisProgramImages.update();
        this.customUniforms.push((Object)this);
    }

    public void restore() {
        if (this.blendModeOverride != null || this.hasOverrides) {
            BlendModeOverride.restore();
        }
    }

    public void setProjectionMatrix(Matrix4fc matrix4fc) {
        if (this.uniformProjectionMatrix != null) {
            this.uniformProjectionMatrix.set(matrix4fc);
        }
        if (this.uniformProjectionMatrixInverse != null) {
            Matrix4f matrix4f = new Matrix4f(matrix4fc);
            matrix4f.invert();
            this.uniformProjectionMatrixInverse.set((Matrix4fc)matrix4f);
        }
    }

    public void setModelViewMatrix(Matrix4fc matrix4fc) {
        if (this.uniformModelViewMatrix != null) {
            this.uniformModelViewMatrix.set(matrix4fc);
        }
        if (this.uniformModelViewMatrixInverse != null) {
            Matrix4f matrix4f = new Matrix4f(matrix4fc);
            matrix4f.invert();
            this.uniformModelViewMatrixInverse.set((Matrix4fc)matrix4f);
            if (this.uniformNormalMatrix != null) {
                matrix4f.transpose();
                this.uniformNormalMatrix.set(new Matrix3f((Matrix4fc)matrix4f));
            }
        } else if (this.uniformNormalMatrix != null) {
            Matrix3f matrix3f = new Matrix3f(matrix4fc);
            matrix3f.invert();
            matrix3f.transpose();
            this.uniformNormalMatrix.set(matrix3f);
        }
    }

    public void setDrawUniforms(GlMutableBuffer glMutableBuffer) {
        if (this.uniformBlockDrawParameters != null) {
            this.uniformBlockDrawParameters.bindBuffer((GlBuffer)glMutableBuffer);
        }
    }

    public void setRegionOffset(float f, float f2, float f3) {
        if (this.uniformRegionOffset != null) {
            this.uniformRegionOffset.set(f, f2, f3);
        }
    }
}

