/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import jerozgen.languagereload.access.ITranslationStorage;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_1078;
import net.minecraft.class_2477;
import net.minecraft.class_2588;
import net.minecraft.class_2590;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2588.class})
abstract class TranslatableTextContentMixin
implements class_7417 {
    @Unique
    @Nullable
    private String previousTargetLanguage;
    @Unique
    private final Map<String, List<class_5348>> separateTranslationsCache = Maps.newHashMap();
    @Unique
    @Nullable
    private List<class_5348> savedTranslations;
    @Shadow
    @Final
    private String field_11876;
    @Shadow
    @Nullable
    private class_2477 field_25317;
    @Shadow
    private List<class_5348> field_11877;

    TranslatableTextContentMixin() {
    }

    @Inject(method={"updateTranslations"}, at={@At(value="RETURN")})
    void onUpdateTranslations(CallbackInfo ci) {
        if (Config.getInstance() == null) {
            return;
        }
        if (!Config.getInstance().multilingualItemSearch) {
            return;
        }
        if (!(this.field_25317 instanceof class_1078)) {
            return;
        }
        String targetLanguage = ((ITranslationStorage)this.field_25317).languagereload_getTargetLanguage();
        if (Objects.equals(this.previousTargetLanguage, targetLanguage)) {
            return;
        }
        if (targetLanguage == null) {
            this.previousTargetLanguage = null;
            this.field_11877 = this.savedTranslations;
            this.savedTranslations = null;
            return;
        }
        if (this.previousTargetLanguage == null) {
            this.savedTranslations = this.field_11877;
        }
        this.previousTargetLanguage = targetLanguage;
        this.field_11877 = this.separateTranslationsCache.computeIfAbsent(targetLanguage, k -> {
            String string = this.field_25317.method_48307(this.field_11876);
            try {
                ImmutableList.Builder builder = new ImmutableList.Builder();
                this.method_11024(string, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                return builder.build();
            }
            catch (class_2590 e) {
                return ImmutableList.of((Object)class_5348.method_29430((String)string));
            }
        });
    }

    @Inject(method={"updateTranslations"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Language;get(Ljava/lang/String;)Ljava/lang/String;")})
    void onUpdateTranslations$clearCache(CallbackInfo ci) {
        this.previousTargetLanguage = null;
        this.separateTranslationsCache.clear();
        this.savedTranslations = null;
    }

    @Shadow
    protected abstract void method_11024(String var1, Consumer<class_5348> var2);
}

