/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.cit;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import shcm.shsupercm.fabric.citresewn.cit.CIT;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.config.CITResewnConfig;

public abstract class CITCache<T extends CITType> {
    public long lastCachedStamp = 0L;

    public static class MultiList<T extends CITType>
    extends CITCache<T> {
        protected List<WeakReference<CIT<T>>> cit = null;
        protected final Function<CITContext, List<CIT<T>>> realtime;

        public MultiList(Function<CITContext, List<CIT<T>>> realtime) {
            this.realtime = realtime;
        }

        public List<WeakReference<CIT<T>>> get(CITContext context) {
            long timeMillis = System.currentTimeMillis();
            if (this.cit == null || timeMillis - this.lastCachedStamp >= (long)CITResewnConfig.INSTANCE.cache_ms) {
                this.cit = new ArrayList<WeakReference<CIT<T>>>();
                for (CIT<T> realtimeCIT : this.realtime.apply(context)) {
                    this.cit.add(new WeakReference<CIT<T>>(realtimeCIT));
                }
            }
            this.lastCachedStamp = timeMillis;
            return this.cit;
        }
    }

    public static class Single<T extends CITType>
    extends CITCache<T> {
        protected WeakReference<CIT<T>> cit = null;
        protected final Function<CITContext, CIT<T>> realtime;

        public Single(Function<CITContext, CIT<T>> realtime) {
            this.realtime = realtime;
        }

        public WeakReference<CIT<T>> get(CITContext context) {
            long timeMillis = System.currentTimeMillis();
            if (this.cit == null || timeMillis - this.lastCachedStamp >= (long)CITResewnConfig.INSTANCE.cache_ms) {
                this.cit = new WeakReference<CIT<CIT<T>>>(this.realtime.apply(context));
            }
            this.lastCachedStamp = timeMillis;
            return this.cit;
        }
    }
}

