/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.gui.ConfigScreen;
import dlovin.inventoryhud.config.gui.EffectsBlacklistScreen;
import dlovin.inventoryhud.config.widgets.ButtonWidget;
import dlovin.inventoryhud.config.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import net.minecraft.class_124;
import net.minecraft.class_437;

public class PotionConfigScreen
extends ConfigScreen {
    public PotionConfigScreen(class_437 prev, boolean inGame) {
        super(prev, 2, inGame);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        String toggle = InventoryHUD.getConfig().getPot() ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        int index = 0;
        this.addButton(index++, toggle, this::ToggleSwitch);
        this.addNumericField(index++, 0, 100, InventoryHUD.getConfig().getPotAlpha(), this::AlphaChanged, 5);
        this.addButton(index++, Boolean.toString(InventoryHUD.getConfig().getPotMini()), this::MiniModeSwitch);
        this.addButton(index++, Boolean.toString(InventoryHUD.getConfig().isPotHor()), this::HorModeSwitch);
        this.addNumericField(index++, -5, 5, InventoryHUD.getConfig().getPotGap(), this::GapChanged, 3);
        this.addNumericField(index++, 1, Integer.MAX_VALUE, InventoryHUD.getConfig().getBarDuration(), this::BarChanged);
        this.addButton(index++, Boolean.toString(InventoryHUD.getConfig().isShowHiddenEffects()), this::HiddenSwitch);
        this.addButton(index++, Boolean.toString(InventoryHUD.getConfig().isPotionLevels()), this::LevelSwitch);
        this.addButton(index++, Boolean.toString(InventoryHUD.getConfig().isPotWithDebug()), this::WithDebug);
        int blEditBtnWidth = Math.min(this.field_22793.method_1727(Translation.BLACKLIST_BTN.getString()) + 8, 40);
        this.addButton(index, blEditBtnWidth, Translation.BLACKLIST_BTN.getString(), b -> this.field_22787.method_1507((class_437)new EffectsBlacklistScreen(this.prevScreen, this.inGame)));
        index = 0;
        this.addText(index++, Translation.POT_TOGGLE.getString(), Translation.POT_TOGGLE_TT);
        this.addText(index++, Translation.POT_ALPHA.getString(), Translation.POT_ALPHA_TT);
        this.addText(index++, Translation.POT_MINI.getString(), Translation.POT_MINI_TT);
        this.addText(index++, Translation.POT_HOR.getString(), Translation.POT_HOR_TT);
        this.addText(index++, Translation.POT_GAP.getString(), Translation.POT_GAP_TT);
        this.addText(index++, Translation.BAR_DUR.getString(), Translation.BAR_DUR_TT);
        this.addText(index++, Translation.HIDDEN_EFFECTS.getString(), Translation.HIDDEN_EFFECTS_TT);
        this.addText(index++, Translation.POTION_LEVELS.getString(), Translation.POTION_LEVELS_TT);
        this.addText(index++, Translation.WITH_DEBUG.getString(), Translation.POT_DEBUG_TT);
        this.addText(index, Translation.BLACKLIST.getString(), Translation.BLACKLIST_TT);
    }

    private void LevelSwitch(ButtonWidget btn) {
        boolean h = !InventoryHUD.getConfig().isPotionLevels();
        btn.setMessage(Boolean.toString(h));
        InventoryHUD.getConfig().setPotionLevels(h);
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.potionLevels = h;
    }

    private void WithDebug(ButtonWidget btn) {
        boolean h = !InventoryHUD.getConfig().isPotWithDebug();
        btn.setMessage(Boolean.toString(h));
        InventoryHUD.getConfig().setPotWithDebug(h);
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.withDebug = h;
    }

    private void HiddenSwitch(ButtonWidget btn) {
        boolean h = !InventoryHUD.getConfig().isShowHiddenEffects();
        btn.setMessage(Boolean.toString(h));
        InventoryHUD.getConfig().setShowHiddenEffects(h);
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.showHidden = h;
    }

    private void BarChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.barDuration = a * 20;
        InventoryHUD.getConfig().setBarDuration(a);
        InventoryHUD.save();
    }

    private void HorModeSwitch(ButtonWidget btn) {
        boolean hor = !InventoryHUD.getConfig().isPotHor();
        InventoryHUD.getConfig().setPotHor(hor);
        InventoryHUD.getInstance().getInvhudGUI().changePotionHor(hor);
        btn.setMessage(Boolean.toString(hor));
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.PotPosChanged();
    }

    private void AlphaChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.potAlpha = (float)a / 100.0f;
        InventoryHUD.getConfig().setPotAlpha(a);
        InventoryHUD.save();
    }

    private void GapChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.potGap = a;
        InventoryHUD.getConfig().setPotGap(a);
    }

    private void ToggleSwitch(ButtonWidget btn) {
        boolean potion;
        InventoryHUD.PotHUD = potion = !InventoryHUD.getConfig().getPot();
        InventoryHUD.getConfig().setPot(potion);
        String toggle = potion ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        btn.setMessage(toggle);
    }

    private void MiniModeSwitch(ButtonWidget btn) {
        boolean mini = !InventoryHUD.getConfig().getPotMini();
        InventoryHUD.getConfig().setPotMini(mini);
        InventoryHUD.getInstance().getInvhudGUI().changePotionMini(mini);
        btn.setMessage("" + mini);
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.PotPosChanged();
    }
}

