/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import dev.emi.trinkets.api.TrinketsApi;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.ArmorRenderer;
import dlovin.inventoryhud.utils.ArmorStatus;
import dlovin.inventoryhud.utils.TrinketSaveUtils;
import dlovin.inventoryhud.utils.TrinketSlot;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.HashMap;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class TrinketRenderer
extends ArmorRenderer {
    HashMap<String, TrinketSlot> slots;

    public TrinketRenderer(class_310 mc) {
        super(mc);
    }

    @Override
    public void render(class_332 context, int width, int height) {
        this.preRender(context, 0, 0);
        this.renderTrinkets(context, width, height);
        this.postRender(context);
    }

    private void renderTrinkets(class_332 context, int width, int height) {
        int[] seed = new int[]{48};
        TrinketsApi.getTrinketComponent((class_1309)this.mc.field_1724).ifPresent(component -> component.forEach((slotReference, stack) -> {
            String slotId = slotReference.inventory().getSlotType().getGroup() + "_" + slotReference.inventory().getSlotType().getName();
            TrinketSlot slot = this.slots().get(slotId);
            seed[0] = this.renderTrinketSlot(context, slot, (class_1799)stack, width, height, seed[0]);
        }));
    }

    private int renderTrinketSlot(class_332 context, TrinketSlot slot, class_1799 stack, int width, int height, int seed) {
        if (slot != null && slot.enabled) {
            int x = this.getX(width, (int)(16.0f * this.armScale), slot.x, slot.aligns.HorAlign);
            int y = this.getY(height, (int)(16.0f * this.armScale), slot.y, slot.aligns.VertAlign);
            boolean right = this.getRight(slot.x, slot.aligns.HorAlign);
            int damage = ArmorStatus.getDamage(stack);
            if (damage >= 0 && damage <= this.armAbove) {
                String text = this.getText(stack, damage);
                this.pushAndRender(context, x, y, !right, null, stack, text, this.armBars, this.armScale, seed++);
            } else if (damage == -2) {
                this.pushAndRender(context, x, y, !right, null, stack, null, true, this.armScale, seed++);
            } else if (this.showEmpty) {
                this.pushAndRender(context, x, y, !right, slot.icon, null, null, false, this.armScale, 0);
            }
        }
        return seed;
    }

    private void pushAndRender(class_332 context, int x, int y, boolean right, class_2960 resourceLocation, class_1799 itemStack, String text, boolean over, float scale, int seed) {
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 0.0);
        matrixStack.method_22905(scale, scale, 1.0f);
        this.renderElement(context, x, y, scale, right, resourceLocation, itemStack, text, over, seed);
        matrixStack.method_22909();
    }

    protected HashMap<String, TrinketSlot> slots() {
        if (this.slots == null) {
            this.setupTrinkets();
        }
        return this.slots;
    }

    public void setupTrinkets() {
        this.slots = new HashMap();
        int[] i = new int[]{0};
        TrinketsApi.getPlayerSlots((class_1657)this.mc.field_1724).forEach((gKey, group) -> group.getSlots().forEach((sKey, slot) -> {
            String slotId = gKey + "_" + sKey;
            i[0] = i[0] + 20;
            this.slots.put(slotId, new TrinketSlot(0, i[0], new WidgetAligns(WidgetAligns.HAlign.LEFT, WidgetAligns.VAlign.TOP), false, slotId, slot.getIcon()));
        }));
        TrinketSaveUtils.sync();
        InventoryHUD.log(String.format("Trinkets have been initialized with %d slot(s)", this.slots.size()));
    }

    public boolean isEmpty() {
        return this.slots().isEmpty();
    }
}

