/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.wildfire.gui.screen.WardrobeBrowserScreen;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.networking.WildfireSync;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_742;

@Environment(value=EnvType.CLIENT)
public class WildfireEventHandler {
    public static final class_304 toggleEditGUI = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.wildfire_gender.gender_menu", class_3675.class_307.field_1668, 71, "category.wildfire_gender.generic"));
    private static long timer = 0L;

    public static void registerClientEvents() {
        ClientEntityEvents.ENTITY_LOAD.register(WildfireEventHandler::onEntityLoad);
        ClientEntityEvents.ENTITY_UNLOAD.register(WildfireEventHandler::onEntityUnload);
        ClientTickEvents.END_CLIENT_TICK.register(WildfireEventHandler::onClientTick);
        ClientPlayConnectionEvents.DISCONNECT.register(WildfireEventHandler::disconnect);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WildfireSync.SYNC_IDENTIFIER, WildfireSync::handle);
    }

    private static void onEntityLoad(class_1297 entity, class_1937 world) {
        if (!world.method_8608() || class_310.method_1551().field_1724 == null) {
            return;
        }
        if (entity instanceof class_742) {
            class_742 plr = (class_742)entity;
            UUID uuid = plr.method_5667();
            PlayerConfig aPlr = WildfireGender.getPlayerById(plr.method_5667());
            if (aPlr == null) {
                aPlr = new PlayerConfig(uuid);
                WildfireGender.PLAYER_CACHE.put(uuid, aPlr);
                WildfireGender.loadGenderInfo(uuid, uuid.equals(class_310.method_1551().field_1724.method_5667()));
            }
        }
    }

    private static void onEntityUnload(class_1297 entity, class_1937 world) {
        EntityConfig.ENTITY_CACHE.remove(entity.method_5667());
    }

    private static void onClientTick(class_310 client) {
        PlayerConfig aPlr;
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (ClientPlayNetworking.canSend((class_2960)WildfireSync.SEND_GENDER_IDENTIFIER) && timer++ % 5L == 0L && (aPlr = WildfireGender.getPlayerById(client.field_1724.method_5667())) != null) {
            WildfireSync.sendToServer(aPlr);
        }
        if (toggleEditGUI.method_1436() && client.field_1755 == null) {
            client.method_1507((class_437)new WardrobeBrowserScreen(null, client.field_1724.method_5667()));
        }
    }

    private static void disconnect(class_634 networkHandler, class_310 client) {
        WildfireGender.PLAYER_CACHE.clear();
        EntityConfig.ENTITY_CACHE.clear();
    }
}

