/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.wildfire.api.IGenderArmor;
import com.wildfire.api.WildfireAPI;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.render.armor.EmptyGenderArmor;
import com.wildfire.render.armor.SimpleGenderArmor;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;

public class WildfireHelper {
    public static int randInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static float randFloat(float min, float max) {
        return (float)ThreadLocalRandom.current().nextDouble(min, (double)max + 1.0);
    }

    public static IGenderArmor getArmorConfig(class_1799 stack) {
        class_1738 armorItem;
        if (stack.method_7960()) {
            return EmptyGenderArmor.INSTANCE;
        }
        if (WildfireAPI.getGenderArmors().get(stack.method_7909()) != null) {
            return WildfireAPI.getGenderArmors().get(stack.method_7909());
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1738 && (armorItem = (class_1738)class_17922).method_7685() == class_1304.field_6174) {
            class_1741 material = armorItem.method_7686();
            if (material == class_1740.field_7897) {
                return SimpleGenderArmor.LEATHER;
            }
            if (material == class_1740.field_7887) {
                return SimpleGenderArmor.CHAIN_MAIL;
            }
            if (material == class_1740.field_7895) {
                return SimpleGenderArmor.GOLD;
            }
            if (material == class_1740.field_7892) {
                return SimpleGenderArmor.IRON;
            }
            if (material == class_1740.field_7889) {
                return SimpleGenderArmor.DIAMOND;
            }
            if (material == class_1740.field_21977) {
                return SimpleGenderArmor.NETHERITE;
            }
            return SimpleGenderArmor.FALLBACK;
        }
        return EmptyGenderArmor.INSTANCE;
    }

    @Environment(value=EnvType.CLIENT)
    public static void drawCenteredText(class_332 ctx, class_327 textRenderer, class_2561 text, int x, int y, int color) {
        int centeredX = x - textRenderer.method_27525((class_5348)text) / 2;
        ctx.method_51439(textRenderer, text, centeredX, y, color, false);
    }

    @Environment(value=EnvType.CLIENT)
    public static void drawScrollableText(class_332 context, class_327 textRenderer, class_2561 text, int left, int top, int right, int bottom, int color) {
        int i = textRenderer.method_27525((class_5348)text);
        int var10000 = top + bottom;
        Objects.requireNonNull(textRenderer);
        int j = (var10000 - 9) / 2 + 1;
        int k = right - left;
        if (i > k) {
            int l = i - k;
            double d = (double)class_156.method_658() / 1000.0;
            double e = Math.max((double)l * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = class_3532.method_16436((double)f, (double)0.0, (double)l);
            context.method_44379(left, top, right, bottom);
            context.method_51439(textRenderer, text, left - (int)g, j, color, false);
            context.method_44380();
        } else {
            WildfireHelper.drawCenteredText(context, textRenderer, text, (left + right) / 2, j, color);
        }
    }

    public static void writeToNbt(@Nonnull class_1657 player, @Nonnull PlayerConfig config, @Nonnull class_1799 armor) {
        class_2487 nbt = new class_2487();
        nbt.method_10548("BreastSize", config.getGender().canHaveBreasts() && config.showBreastsInArmor() ? config.getBustSize() : 0.0f);
        nbt.method_10548("Cleavage", config.getBreasts().getCleavage());
        nbt.method_10556("Uniboob", config.getBreasts().isUniboob());
        nbt.method_10548("XOffset", config.getBreasts().getXOffset());
        nbt.method_10548("YOffset", config.getBreasts().getYOffset());
        nbt.method_10548("ZOffset", config.getBreasts().getZOffset());
        nbt.method_10556("Jacket", player.method_7348(class_1664.field_7564));
        armor.method_7959("WildfireGender", (class_2520)nbt);
    }
}

