/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import com.wildfire.main.config.BooleanConfigKey;
import com.wildfire.main.config.ConfigKey;
import com.wildfire.main.config.FloatConfigKey;
import com.wildfire.main.config.StringConfigKey;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class BreastPresetConfiguration {
    public static final StringConfigKey PRESET_NAME = new StringConfigKey("preset_name", "");
    public static final FloatConfigKey BUST_SIZE = new FloatConfigKey("bust_size", 0.6f, 0.0f, 0.8f);
    public static final FloatConfigKey BREASTS_OFFSET_X = new FloatConfigKey("breasts_xOffset", 0.0f, -1.0f, 1.0f);
    public static final FloatConfigKey BREASTS_OFFSET_Y = new FloatConfigKey("breasts_yOffset", 0.0f, -1.0f, 1.0f);
    public static final FloatConfigKey BREASTS_OFFSET_Z = new FloatConfigKey("breasts_zOffset", 0.0f, -1.0f, 0.0f);
    public static final BooleanConfigKey BREASTS_UNIBOOB = new BooleanConfigKey("breasts_uniboob", true);
    public static final FloatConfigKey BREASTS_CLEAVAGE = new FloatConfigKey("breasts_cleavage", 0.0f, 0.0f, 0.1f);
    private static final TypeAdapter<JsonObject> ADAPTER = new Gson().getAdapter(JsonObject.class);
    private final File CFG_FILE;
    public JsonObject SAVE_VALUES = new JsonObject();

    public BreastPresetConfiguration(String cfgName) {
        Path saveDir = FabricLoader.getInstance().getConfigDir();
        System.out.println("Breast Presets Save Dir: " + saveDir.toString());
        if (!Files.isDirectory(saveDir.resolve("WildfireGender/presets"), new LinkOption[0])) {
            try {
                Files.createDirectory(saveDir.resolve("WildfireGender/presets"), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.CFG_FILE = saveDir.resolve("WildfireGender/presets").resolve(cfgName + ".json").toFile();
    }

    public static BreastPresetConfiguration[] getBreastPresetConfigurationFiles() {
        File[] presetFiles;
        ArrayList<BreastPresetConfiguration> tmp = new ArrayList<BreastPresetConfiguration>();
        Path saveDir = FabricLoader.getInstance().getConfigDir();
        File presetFileLocation = saveDir.resolve("WildfireGender/presets").toFile();
        if (!presetFileLocation.exists()) {
            presetFileLocation.mkdirs();
        }
        if ((presetFiles = presetFileLocation.listFiles()).length > 0) {
            for (File f : presetFiles) {
                BreastPresetConfiguration cfg = new BreastPresetConfiguration(f.getName().replace(".json", ""));
                cfg.load();
                tmp.add(cfg);
            }
        }
        if (tmp.size() == 0) {
            return new BreastPresetConfiguration[0];
        }
        return tmp.toArray(new BreastPresetConfiguration[tmp.size()]);
    }

    public void finish() {
        if (this.CFG_FILE.exists()) {
            this.load();
            this.updateConfig();
        }
    }

    public <TYPE> void set(ConfigKey<TYPE> key, TYPE value) {
        key.save(this.SAVE_VALUES, value);
    }

    public <TYPE> TYPE get(ConfigKey<TYPE> key) {
        return key.read(this.SAVE_VALUES);
    }

    public void removeParameter(ConfigKey<?> key) {
        this.removeParameter(key.key);
    }

    public void removeParameter(String key) {
        this.SAVE_VALUES.remove(key);
    }

    public void updateConfig() {
        JsonObject obj;
        try (FileReader configurationFile = new FileReader(this.CFG_FILE);){
            obj = (JsonObject)new Gson().fromJson((Reader)configurationFile, JsonObject.class);
            for (Map.Entry entry : this.SAVE_VALUES.entrySet()) {
                obj.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        catch (Exception ignored) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.CFG_FILE);
             JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            ADAPTER.write(jsonWriter, (Object)obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.CFG_FILE);
             JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            jsonWriter.setIndent("\t\t");
            ADAPTER.write(jsonWriter, (Object)this.SAVE_VALUES);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void load() {
        try (FileReader configurationFile = new FileReader(this.CFG_FILE);){
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)configurationFile, JsonObject.class);
            for (Map.Entry entry : obj.entrySet()) {
                String key = (String)entry.getKey();
                this.SAVE_VALUES.add(key, (JsonElement)entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

